/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.service.KaleoConditionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTransitionLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoDefinitionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoDefinition"}, service={AopService.class})
public class KaleoDefinitionLocalServiceImpl
extends KaleoDefinitionLocalServiceBaseImpl {
    @Reference
    private KaleoConditionLocalService _kaleoConditionLocalService;
    @Reference
    private KaleoDefinitionVersionLocalService _kaleoDefinitionVersionLocalService;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference
    private KaleoNodeLocalService _kaleoNodeLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference
    private KaleoTransitionLocalService _kaleoTransitionLocalService;
    @Reference
    private Staging _staging;

    public void activateKaleoDefinition(long kaleoDefinitionId, long kaleoDefinitionVersionId, long startKaleoNodeId, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByPrimaryKey(kaleoDefinitionId);
        kaleoDefinition.setModifiedDate(new Date());
        kaleoDefinition.setActive(true);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
        KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionPersistence.findByPrimaryKey(kaleoDefinitionVersionId);
        kaleoDefinitionVersion.setModifiedDate(new Date());
        kaleoDefinitionVersion.setStartKaleoNodeId(startKaleoNodeId);
        this.kaleoDefinitionVersionPersistence.update((BaseModel)kaleoDefinitionVersion);
    }

    public void activateKaleoDefinition(long kaleoDefinitionId, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByPrimaryKey(kaleoDefinitionId);
        kaleoDefinition.setModifiedDate(new Date());
        kaleoDefinition.setActive(true);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
    }

    public void activateKaleoDefinition(String name, int version, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByC_N_V(serviceContext.getCompanyId(), name, version);
        kaleoDefinition.setModifiedDate(new Date());
        kaleoDefinition.setActive(true);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
    }

    @Deprecated
    public KaleoDefinition addKaleoDefinition(String name, String title, String description, String content, int version, ServiceContext serviceContext) throws PortalException {
        return this.kaleoDefinitionLocalService.addKaleoDefinition(name, title, description, content, "all", version, serviceContext);
    }

    public KaleoDefinition addKaleoDefinition(String name, String title, String description, String content, String scope, int version, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoDefinitionId = this.counterLocalService.increment();
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.create(kaleoDefinitionId);
        long groupId = this._staging.getLiveGroupId(serviceContext.getScopeGroupId());
        kaleoDefinition.setGroupId(groupId);
        kaleoDefinition.setCompanyId(user.getCompanyId());
        kaleoDefinition.setUserId(user.getUserId());
        kaleoDefinition.setUserName(user.getFullName());
        kaleoDefinition.setCreateDate(date);
        kaleoDefinition.setModifiedDate(date);
        kaleoDefinition.setName(name);
        kaleoDefinition.setTitle(title);
        kaleoDefinition.setDescription(description);
        kaleoDefinition.setContent(content);
        kaleoDefinition.setScope(scope);
        kaleoDefinition.setVersion(version);
        kaleoDefinition.setActive(false);
        kaleoDefinition = (KaleoDefinition)this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
        this._kaleoDefinitionVersionLocalService.addKaleoDefinitionVersion(kaleoDefinitionId, name, title, description, content, this.getVersion(version), serviceContext);
        return kaleoDefinition;
    }

    public void deactivateKaleoDefinition(String name, int version, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByC_N_V(serviceContext.getCompanyId(), name, version);
        kaleoDefinition.setModifiedDate(new Date());
        kaleoDefinition.setActive(false);
        this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
    }

    public void deleteCompanyKaleoDefinitions(long companyId) {
        this.kaleoDefinitionPersistence.removeByCompanyId(companyId);
        this.kaleoDefinitionVersionPersistence.removeByCompanyId(companyId);
        this._kaleoConditionLocalService.deleteCompanyKaleoConditions(companyId);
        this._kaleoInstanceLocalService.deleteCompanyKaleoInstances(companyId);
        this._kaleoNodeLocalService.deleteCompanyKaleoNodes(companyId);
        this._kaleoTaskLocalService.deleteCompanyKaleoTasks(companyId);
        this._kaleoTransitionLocalService.deleteCompanyKaleoTransitions(companyId);
    }

    public void deleteKaleoDefinition(String name, ServiceContext serviceContext) throws PortalException {
        KaleoDefinition kaleoDefinition = this.getKaleoDefinition(name, serviceContext);
        if (kaleoDefinition.isActive()) {
            throw new WorkflowException("Cannot delete active workflow definition " + kaleoDefinition.getKaleoDefinitionId());
        }
        this.kaleoDefinitionPersistence.remove((BaseModel)kaleoDefinition);
        this._kaleoDefinitionVersionLocalService.deleteKaleoDefinitionVersions(kaleoDefinition);
    }

    public KaleoDefinition fetchKaleoDefinition(String name, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.fetchByC_N(serviceContext.getCompanyId(), name);
    }

    public KaleoDefinition getKaleoDefinition(String name, ServiceContext serviceContext) throws PortalException {
        return this.kaleoDefinitionPersistence.findByC_N(serviceContext.getCompanyId(), name);
    }

    public List<KaleoDefinition> getKaleoDefinitions(boolean active, int start, int end, OrderByComparator<KaleoDefinition> orderByComparator, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.findByC_A(serviceContext.getCompanyId(), active, start, end, orderByComparator);
    }

    public List<KaleoDefinition> getKaleoDefinitions(int start, int end, OrderByComparator<KaleoDefinition> orderByComparator, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.findByCompanyId(serviceContext.getCompanyId(), start, end, orderByComparator);
    }

    public int getKaleoDefinitionsCount(boolean active, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByC_A(serviceContext.getCompanyId(), active);
    }

    public int getKaleoDefinitionsCount(ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByCompanyId(serviceContext.getCompanyId());
    }

    public int getKaleoDefinitionsCount(String name, boolean active, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByC_N_A(serviceContext.getCompanyId(), name, active);
    }

    public int getKaleoDefinitionsCount(String name, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByC_N(serviceContext.getCompanyId(), name);
    }

    public List<KaleoDefinition> getScopeKaleoDefinitions(String scope, boolean active, int start, int end, OrderByComparator<KaleoDefinition> orderByComparator, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.findByC_S_A(serviceContext.getCompanyId(), scope, active, start, end, orderByComparator);
    }

    public List<KaleoDefinition> getScopeKaleoDefinitions(String scope, int start, int end, OrderByComparator<KaleoDefinition> orderByComparator, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.findByC_S(serviceContext.getCompanyId(), scope, start, end, orderByComparator);
    }

    public int getScopeKaleoDefinitionsCount(String scope, boolean active, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByC_S_A(serviceContext.getCompanyId(), scope, active);
    }

    public int getScopeKaleoDefinitionsCount(String scope, ServiceContext serviceContext) {
        return this.kaleoDefinitionPersistence.countByC_S(serviceContext.getCompanyId(), scope);
    }

    public KaleoDefinition updatedKaleoDefinition(long kaleoDefinitionId, String title, String description, String content, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        KaleoDefinition kaleoDefinition = this.kaleoDefinitionPersistence.findByPrimaryKey(kaleoDefinitionId);
        long groupId = this._staging.getLiveGroupId(serviceContext.getScopeGroupId());
        kaleoDefinition.setGroupId(groupId);
        kaleoDefinition.setUserId(user.getUserId());
        kaleoDefinition.setUserName(user.getFullName());
        kaleoDefinition.setCreateDate(date);
        kaleoDefinition.setModifiedDate(date);
        kaleoDefinition.setTitle(title);
        kaleoDefinition.setDescription(description);
        kaleoDefinition.setContent(content);
        int nextVersion = kaleoDefinition.getVersion() + 1;
        kaleoDefinition.setVersion(nextVersion);
        kaleoDefinition.setActive(false);
        kaleoDefinition = (KaleoDefinition)this.kaleoDefinitionPersistence.update((BaseModel)kaleoDefinition);
        this._kaleoDefinitionVersionLocalService.addKaleoDefinitionVersion(kaleoDefinitionId, kaleoDefinition.getName(), title, description, content, this.getVersion(nextVersion), serviceContext);
        return kaleoDefinition;
    }

    protected String getVersion(int version) {
        return version + "." + 0;
    }
}

