/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.exception.NoSuchInstanceException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoInstanceLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoInstancePersistence;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoInstanceQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstance"}, service={AopService.class})
public class KaleoInstanceLocalServiceImpl
extends KaleoInstanceLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KaleoInstanceLocalServiceImpl.class);
    private static final Map<String, String> _fieldNameOrderByCols = HashMapBuilder.put((Object)"completed", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("completed", "String")).put((Object)"completionDate", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("completionDate", "Number")).put((Object)"createDate", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("createDate", "Number")).put((Object)"kaleoInstanceId", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("kaleoInstanceId", "Number")).put((Object)"modifiedDate", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("modified", "Number")).put((Object)"state", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("currentKaleoNodeName", "String")).build();
    private static final Map<String, Integer> _fieldNameSortTypes = HashMapBuilder.put((Object)"createDate", (Object)6).put((Object)"modified", (Object)6).put((Object)"completionDate", (Object)6).build();
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoTimerInstanceTokenLocalService _kaleoTimerInstanceTokenLocalService;
    @Reference
    private Staging _staging;

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstance addKaleoInstance(long kaleoDefinitionId, long kaleoDefinitionVersionId, String kaleoDefinitionName, int kaleoDefinitionVersion, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.fetchUser(serviceContext.getUserId());
        if (user == null) {
            user = this.userLocalService.getDefaultUser(serviceContext.getCompanyId());
        }
        Date date = new Date();
        long kaleoInstanceId = this.counterLocalService.increment();
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.create(kaleoInstanceId);
        long groupId = this._staging.getLiveGroupId(serviceContext.getScopeGroupId());
        kaleoInstance.setGroupId(groupId);
        kaleoInstance.setCompanyId(user.getCompanyId());
        kaleoInstance.setUserId(user.getUserId());
        kaleoInstance.setUserName(user.getFullName());
        kaleoInstance.setCreateDate(date);
        kaleoInstance.setModifiedDate(date);
        kaleoInstance.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoInstance.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoInstance.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstance.setKaleoDefinitionVersion(kaleoDefinitionVersion);
        kaleoInstance.setClassName((String)((Object)workflowContext.get("entryClassName")));
        if (workflowContext.containsKey("entryClassPK")) {
            kaleoInstance.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
        }
        kaleoInstance.setCompleted(false);
        kaleoInstance.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstance completeKaleoInstance(long kaleoInstanceId) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setCompleted(true);
        kaleoInstance.setCompletionDate(new Date());
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    public void deleteCompanyKaleoInstances(long companyId) {
        for (KaleoInstance kaleoInstance : this.kaleoInstancePersistence.findByCompanyId(companyId)) {
            this.kaleoInstanceLocalService.deleteKaleoInstance(kaleoInstance);
        }
        this._kaleoInstanceTokenLocalService.deleteCompanyKaleoInstanceTokens(companyId);
        this._kaleoLogLocalService.deleteCompanyKaleoLogs(companyId);
        this._kaleoTaskInstanceTokenLocalService.deleteCompanyKaleoTaskInstanceTokens(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoInstances(long kaleoDefinitionVersionId) {
        for (KaleoInstance kaleoInstance : this.kaleoInstancePersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId)) {
            this.kaleoInstanceLocalService.deleteKaleoInstance(kaleoInstance);
        }
        this._kaleoInstanceTokenLocalService.deleteKaleoDefinitionVersionKaleoInstanceTokens(kaleoDefinitionVersionId);
        this._kaleoLogLocalService.deleteKaleoDefinitionVersionKaleoLogs(kaleoDefinitionVersionId);
        this._kaleoTaskInstanceTokenLocalService.deleteKaleoDefinitionVersionKaleoTaskInstanceTokens(kaleoDefinitionVersionId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public KaleoInstance deleteKaleoInstance(long kaleoInstanceId) {
        KaleoInstance kaleoInstance = null;
        try {
            kaleoInstance = this.kaleoInstancePersistence.remove(kaleoInstanceId);
        }
        catch (NoSuchInstanceException noSuchInstanceException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchInstanceException, (Throwable)noSuchInstanceException);
            }
            return null;
        }
        this._kaleoInstanceTokenLocalService.deleteKaleoInstanceKaleoInstanceTokens(kaleoInstanceId);
        this._kaleoLogLocalService.deleteKaleoInstanceKaleoLogs(kaleoInstanceId);
        this._kaleoTaskInstanceTokenLocalService.deleteKaleoInstanceKaleoTaskInstanceTokens(kaleoInstanceId);
        this._kaleoTimerInstanceTokenLocalService.deleteKaleoTimerInstanceTokens(kaleoInstanceId);
        return kaleoInstance;
    }

    public KaleoInstance fetchKaleoInstance(long kaleoInstanceId, long companyId, long userId) {
        return this.kaleoInstancePersistence.fetchByKII_C_U(kaleoInstanceId, companyId, userId);
    }

    public int getKaleoDefinitionKaleoInstancesCount(long kaleoDefinitionId, boolean completed) {
        return this.kaleoInstancePersistence.countByKDI_C(kaleoDefinitionId, completed);
    }

    public List<KaleoInstance> getKaleoInstances(Long userId, String assetClassName, Long assetClassPK, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        return this.doSearch(userId, null, null, this.getClassNames(assetClassName), assetClassPK, completed, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoInstance> getKaleoInstances(Long userId, String[] assetClassNames, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        return this.doSearch(userId, null, null, assetClassNames, null, completed, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoInstance> getKaleoInstances(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        return this.doSearch(null, kaleoDefinitionName, kaleoDefinitionVersion, null, null, completed, start, end, orderByComparator, serviceContext);
    }

    public int getKaleoInstancesCount(long kaleoDefinitionVersionId, boolean completed) {
        return this.kaleoInstancePersistence.countByKDVI_C(kaleoDefinitionVersionId, completed);
    }

    public int getKaleoInstancesCount(Long userId, String assetClassName, Long assetClassPK, Boolean completed, ServiceContext serviceContext) {
        return this.doSearchCount(userId, null, null, this.getClassNames(assetClassName), assetClassPK, completed, serviceContext);
    }

    public int getKaleoInstancesCount(Long userId, String[] assetClassNames, Boolean completed, ServiceContext serviceContext) {
        return this.doSearchCount(userId, null, null, assetClassNames, null, completed, serviceContext);
    }

    public int getKaleoInstancesCount(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, ServiceContext serviceContext) {
        return this.doSearchCount(null, kaleoDefinitionName, kaleoDefinitionVersion, null, null, completed, serviceContext);
    }

    @Deprecated
    public List<KaleoInstance> search(Long userId, String assetClassName, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        return this.search(userId, assetClassName, null, null, nodeName, kaleoDefinitionName, completed, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoInstance> search(Long userId, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        try {
            BaseModelSearchResult<KaleoInstance> baseModelSearchResult = this.searchKaleoInstances(userId, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, start, end, orderByComparator, serviceContext);
            return baseModelSearchResult.getBaseModels();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return Collections.emptyList();
        }
    }

    @Deprecated
    public int searchCount(Long userId, String assetClassName, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) {
        return this.searchCount(userId, assetClassName, null, null, nodeName, kaleoDefinitionName, completed, serviceContext);
    }

    public int searchCount(Long userId, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) {
        return this._kaleoInstanceTokenLocalService.searchCount(userId, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, serviceContext);
    }

    public BaseModelSearchResult<KaleoInstance> searchKaleoInstances(Long userId, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) throws PortalException {
        ArrayList<KaleoInstance> kaleoInstances = new ArrayList<KaleoInstance>();
        Hits hits = this._kaleoInstanceTokenLocalService.search(userId, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, start, end, this.getSortsFromComparator(orderByComparator), serviceContext);
        for (Document document : hits.getDocs()) {
            long kaleoInstanceId = GetterUtil.getLong((String)document.get("kaleoInstanceId"));
            KaleoInstance kaleoInstance = this.kaleoInstancePersistence.fetchByPrimaryKey(kaleoInstanceId);
            if (kaleoInstance == null) continue;
            kaleoInstances.add(kaleoInstance);
        }
        return new BaseModelSearchResult(kaleoInstances, hits.getLength());
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstance updateKaleoInstance(long kaleoInstanceId, long rootKaleoInstanceTokenId) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setRootKaleoInstanceTokenId(rootKaleoInstanceTokenId);
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstance updateKaleoInstance(long kaleoInstanceId, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    protected SearchContext buildSearchContext(Map<String, Serializable> searchAttributes, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes(searchAttributes);
        searchContext.setCompanyId(serviceContext.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{-1L});
        searchContext.setStart(start);
        if (orderByComparator != null) {
            searchContext.setSorts(this.getSortsFromComparator(orderByComparator));
        }
        searchContext.setUserId(serviceContext.getUserId());
        return searchContext;
    }

    protected List<KaleoInstance> doSearch(Long userId, String kaleoDefinitionName, Integer kaleoDefinitionVersion, String[] classNames, Long classPK, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        KaleoInstanceQuery kaleoInstanceQuery = new KaleoInstanceQuery(serviceContext);
        kaleoInstanceQuery.setClassNames(classNames);
        kaleoInstanceQuery.setClassPK(classPK);
        kaleoInstanceQuery.setCompleted(completed);
        kaleoInstanceQuery.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstanceQuery.setKaleoDefinitionVersion(kaleoDefinitionVersion);
        kaleoInstanceQuery.setUserId(userId);
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoInstance.class.getName());
            Hits hits = indexer.search(this.buildSearchContext(HashMapBuilder.put((Object)"kaleoInstanceQuery", (Object)kaleoInstanceQuery).build(), start, end, orderByComparator, serviceContext));
            return Stream.of(hits.getDocs()).map(document -> GetterUtil.getLong((String)document.get("entryClassPK"))).map(arg_0 -> ((KaleoInstancePersistence)this.kaleoInstancePersistence).fetchByPrimaryKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return Collections.emptyList();
        }
    }

    protected int doSearchCount(Long userId, String kaleoDefinitionName, Integer kaleoDefinitionVersion, String[] classNames, Long classPK, boolean completed, ServiceContext serviceContext) {
        KaleoInstanceQuery kaleoInstanceQuery = new KaleoInstanceQuery(serviceContext);
        kaleoInstanceQuery.setClassNames(classNames);
        kaleoInstanceQuery.setClassPK(classPK);
        kaleoInstanceQuery.setCompleted(Boolean.valueOf(completed));
        kaleoInstanceQuery.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstanceQuery.setKaleoDefinitionVersion(kaleoDefinitionVersion);
        kaleoInstanceQuery.setUserId(userId);
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoInstance.class.getName());
            return (int)indexer.searchCount(this.buildSearchContext(HashMapBuilder.put((Object)"kaleoInstanceQuery", (Object)kaleoInstanceQuery).build(), -1, -1, null, serviceContext));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return 0;
        }
    }

    protected String[] getClassNames(String className) {
        if (Validator.isNull((String)className)) {
            return null;
        }
        return new String[]{className};
    }

    protected Sort[] getSortsFromComparator(OrderByComparator<KaleoInstance> orderByComparator) {
        if (orderByComparator == null) {
            return null;
        }
        return (Sort[])Stream.of(orderByComparator.getOrderByFields()).map(orderByFieldName -> {
            String fieldName = _fieldNameOrderByCols.getOrDefault(orderByFieldName, (String)orderByFieldName);
            int sortType = _fieldNameSortTypes.getOrDefault(fieldName, 3);
            boolean ascending = orderByComparator.isAscending();
            if (Objects.equals(orderByFieldName, "completed")) {
                ascending = true;
            }
            return new Sort(fieldName, sortType, !ascending);
        }).toArray(Sort[]::new);
    }

    private static String _getSortableFieldName(String name, String type) {
        return Field.getSortableFieldName((String)StringBundler.concat((String[])new String[]{name, "_", type}));
    }
}

