/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.LogType;
import com.liferay.portal.workflow.kaleo.definition.util.KaleoLogUtil;
import com.liferay.portal.workflow.kaleo.exception.NoSuchLogException;
import com.liferay.portal.workflow.kaleo.model.KaleoAction;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoLog;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoLogLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoLogPersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoLog"}, service={AopService.class})
public class KaleoLogLocalServiceImpl
extends KaleoLogLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KaleoLogLocalServiceImpl.class);
    private static final Map<String, String> _fieldNameOrderByCols = HashMapBuilder.put((Object)"createDate", (Object)KaleoLogLocalServiceImpl._getSortableFieldName("createDate", "Number")).put((Object)"kaleoLogId", (Object)KaleoLogLocalServiceImpl._getSortableFieldName("kaleoLogId", "Number")).put((Object)"modifiedDate", (Object)KaleoLogLocalServiceImpl._getSortableFieldName("modified", "Number")).put((Object)"userId", (Object)KaleoLogLocalServiceImpl._getSortableFieldName("userId", "Number")).build();
    private static final Map<String, Integer> _fieldNameSortTypes = HashMapBuilder.put((Object)"createDate", (Object)6).put((Object)"modified", (Object)6).build();

    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addActionExecutionKaleoLog(KaleoInstanceToken kaleoInstanceToken, KaleoAction kaleoAction, long startTime, long endTime, String comment, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.ACTION_EXECUTION, serviceContext);
        kaleoLog.setKaleoClassName(kaleoAction.getKaleoClassName());
        kaleoLog.setKaleoClassPK(kaleoAction.getKaleoClassPK());
        kaleoLog.setKaleoDefinitionId(kaleoAction.getKaleoDefinitionId());
        kaleoLog.setKaleoDefinitionVersionId(kaleoAction.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(kaleoAction.getKaleoNodeName());
        kaleoLog.setComment(comment);
        kaleoLog.setStartDate(new Date(startTime));
        kaleoLog.setEndDate(new Date(endTime));
        kaleoLog.setDuration(endTime - startTime);
        return (KaleoLog)this.kaleoLogPersistence.update((BaseModel)kaleoLog);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addNodeEntryKaleoLog(KaleoInstanceToken kaleoInstanceToken, KaleoNode sourceKaleoNode, KaleoNode targetKaleoNode, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.NODE_ENTRY, serviceContext);
        kaleoLog.setKaleoClassName(KaleoNode.class.getName());
        kaleoLog.setKaleoClassPK(targetKaleoNode.getKaleoNodeId());
        kaleoLog.setKaleoDefinitionId(targetKaleoNode.getKaleoDefinitionId());
        kaleoLog.setKaleoDefinitionVersionId(targetKaleoNode.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(targetKaleoNode.getName());
        kaleoLog.setTerminalKaleoNode(targetKaleoNode.isTerminal());
        if (sourceKaleoNode != null) {
            kaleoLog.setPreviousKaleoNodeId(sourceKaleoNode.getKaleoNodeId());
            kaleoLog.setPreviousKaleoNodeName(sourceKaleoNode.getName());
        }
        kaleoLog.setStartDate(kaleoLog.getCreateDate());
        return (KaleoLog)this.kaleoLogPersistence.update((BaseModel)kaleoLog);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addNodeExitKaleoLog(KaleoInstanceToken kaleoInstanceToken, KaleoNode departingKaleoNode, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog;
        block2: {
            kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.NODE_EXIT, serviceContext);
            kaleoLog.setKaleoClassName(KaleoNode.class.getName());
            kaleoLog.setKaleoClassPK(departingKaleoNode.getKaleoNodeId());
            kaleoLog.setKaleoDefinitionId(departingKaleoNode.getKaleoDefinitionId());
            kaleoLog.setKaleoDefinitionVersionId(departingKaleoNode.getKaleoDefinitionVersionId());
            kaleoLog.setKaleoNodeName(departingKaleoNode.getName());
            kaleoLog.setEndDate(kaleoLog.getCreateDate());
            try {
                KaleoLog previousKaleoLog = this.getPreviousLog(kaleoLog.getKaleoInstanceTokenId(), kaleoLog.getKaleoClassPK(), LogType.WORKFLOW_INSTANCE_START);
                Date startDate = previousKaleoLog.getStartDate();
                Date endDate = kaleoLog.getEndDate();
                kaleoLog.setDuration(endDate.getTime() - startDate.getTime());
            }
            catch (NoSuchLogException noSuchLogException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)noSuchLogException, (Throwable)noSuchLogException);
            }
        }
        return (KaleoLog)this.kaleoLogPersistence.update((BaseModel)kaleoLog);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addTaskAssignmentKaleoLog(List<KaleoTaskAssignmentInstance> previousKaleoTaskAssignmentInstances, KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance, KaleoTaskInstanceToken kaleoTaskInstanceToken, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.TASK_ASSIGNMENT, serviceContext);
        kaleoLog.setKaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        KaleoNode currentKaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
        kaleoLog.setKaleoClassName(KaleoNode.class.getName());
        kaleoLog.setKaleoClassPK(currentKaleoNode.getKaleoNodeId());
        kaleoLog.setKaleoDefinitionId(currentKaleoNode.getKaleoDefinitionId());
        kaleoLog.setKaleoDefinitionVersionId(currentKaleoNode.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(currentKaleoNode.getName());
        if (previousKaleoTaskAssignmentInstances != null && previousKaleoTaskAssignmentInstances.size() == 1) {
            KaleoTaskAssignmentInstance previousKaleoTaskAssignmentInstance = previousKaleoTaskAssignmentInstances.get(0);
            kaleoLog.setPreviousAssigneeClassName(previousKaleoTaskAssignmentInstance.getAssigneeClassName());
            kaleoLog.setPreviousAssigneeClassPK(previousKaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        if (kaleoTaskAssignmentInstance != null) {
            kaleoLog.setCurrentAssigneeClassName(kaleoTaskAssignmentInstance.getAssigneeClassName());
            kaleoLog.setCurrentAssigneeClassPK(kaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        kaleoLog.setComment(comment);
        kaleoLog.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        return (KaleoLog)this.kaleoLogPersistence.update((BaseModel)kaleoLog);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addTaskAssignmentKaleoLog(List<KaleoTaskAssignmentInstance> previousKaleoTaskAssignmentInstances, KaleoTaskInstanceToken kaleoTaskInstanceToken, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = null;
        List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        if (ListUtil.isNotEmpty((List)kaleoTaskAssignmentInstances)) {
            kaleoTaskAssignmentInstance = (KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstances.get(0);
        }
        return this.addTaskAssignmentKaleoLog(previousKaleoTaskAssignmentInstances, kaleoTaskAssignmentInstance, kaleoTaskInstanceToken, comment, workflowContext, serviceContext);
    }

    public List<KaleoLog> addTaskAssignmentKaleoLogs(List<KaleoTaskAssignmentInstance> previousTaskAssignmentInstances, KaleoTaskInstanceToken kaleoTaskInstanceToken, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        ArrayList<KaleoLog> kaleoLogs = new ArrayList<KaleoLog>();
        for (KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance : kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances()) {
            kaleoLogs.add(this.kaleoLogLocalService.addTaskAssignmentKaleoLog(previousTaskAssignmentInstances, kaleoTaskAssignmentInstance, kaleoTaskInstanceToken, comment, workflowContext, serviceContext));
        }
        if (ListUtil.isEmpty(kaleoLogs)) {
            kaleoLogs.add(this.kaleoLogLocalService.addTaskAssignmentKaleoLog(previousTaskAssignmentInstances, null, kaleoTaskInstanceToken, comment, workflowContext, serviceContext));
        }
        return kaleoLogs;
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addTaskCompletionKaleoLog(KaleoTaskInstanceToken kaleoTaskInstanceToken, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = kaleoTaskInstanceToken.getKaleoInstanceToken();
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.TASK_COMPLETION, serviceContext);
        kaleoLog.setKaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        KaleoNode currentKaleoNode = kaleoInstanceToken.getCurrentKaleoNode();
        kaleoLog.setKaleoClassName(KaleoNode.class.getName());
        kaleoLog.setKaleoClassPK(currentKaleoNode.getKaleoNodeId());
        kaleoLog.setKaleoDefinitionId(currentKaleoNode.getKaleoDefinitionId());
        kaleoLog.setKaleoDefinitionVersionId(currentKaleoNode.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoNodeName(currentKaleoNode.getName());
        List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        if (!kaleoTaskAssignmentInstances.isEmpty()) {
            KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = (KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstances.get(0);
            kaleoLog.setCurrentAssigneeClassName(kaleoTaskAssignmentInstance.getAssigneeClassName());
            kaleoLog.setCurrentAssigneeClassPK(kaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        kaleoLog.setComment(comment);
        kaleoLog.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        return (KaleoLog)this.kaleoLogPersistence.update((BaseModel)kaleoLog);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addTaskUpdateKaleoLog(KaleoTaskInstanceToken kaleoTaskInstanceToken, String comment, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoTaskInstanceToken.getKaleoInstanceToken(), LogType.TASK_UPDATE, serviceContext);
        kaleoLog.setKaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        if (!kaleoTaskAssignmentInstances.isEmpty()) {
            KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance = (KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstances.get(0);
            kaleoLog.setCurrentAssigneeClassName(kaleoTaskAssignmentInstance.getAssigneeClassName());
            kaleoLog.setCurrentAssigneeClassPK(kaleoTaskAssignmentInstance.getAssigneeClassPK());
        }
        kaleoLog.setComment(comment);
        kaleoLog.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        return (KaleoLog)this.kaleoLogPersistence.update((BaseModel)kaleoLog);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addWorkflowInstanceEndKaleoLog(KaleoInstanceToken kaleoInstanceToken, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog;
        block2: {
            kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.WORKFLOW_INSTANCE_END, serviceContext);
            kaleoLog.setEndDate(kaleoLog.getCreateDate());
            try {
                KaleoLog previousKaleoLog = this.getPreviousLog(kaleoLog.getKaleoInstanceTokenId(), 0L, LogType.WORKFLOW_INSTANCE_START);
                Date startDate = previousKaleoLog.getStartDate();
                Date endDate = kaleoLog.getEndDate();
                kaleoLog.setDuration(endDate.getTime() - startDate.getTime());
            }
            catch (NoSuchLogException noSuchLogException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)noSuchLogException, (Throwable)noSuchLogException);
            }
        }
        return (KaleoLog)this.kaleoLogPersistence.update((BaseModel)kaleoLog);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoLog addWorkflowInstanceStartKaleoLog(KaleoInstanceToken kaleoInstanceToken, ServiceContext serviceContext) throws PortalException {
        KaleoLog kaleoLog = this.createKaleoLog(kaleoInstanceToken, LogType.WORKFLOW_INSTANCE_START, serviceContext);
        kaleoLog.setStartDate(kaleoLog.getCreateDate());
        KaleoInstance kaleoInstance = kaleoInstanceToken.getKaleoInstance();
        kaleoLog.setWorkflowContext(kaleoInstance.getWorkflowContext());
        return (KaleoLog)this.kaleoLogPersistence.update((BaseModel)kaleoLog);
    }

    public void deleteCompanyKaleoLogs(long companyId) {
        for (KaleoLog kaleoLog : this.kaleoLogPersistence.findByCompanyId(companyId)) {
            this.kaleoLogLocalService.deleteKaleoLog(kaleoLog);
        }
    }

    public void deleteKaleoDefinitionVersionKaleoLogs(long kaleoDefinitionVersionId) {
        for (KaleoLog kaleoLog : this.kaleoLogPersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId)) {
            this.kaleoLogLocalService.deleteKaleoLog(kaleoLog);
        }
    }

    public void deleteKaleoInstanceKaleoLogs(long kaleoInstanceId) {
        for (KaleoLog kaleoLog : this.kaleoLogPersistence.findByKaleoInstanceId(kaleoInstanceId)) {
            this.kaleoLogLocalService.deleteKaleoLog(kaleoLog);
        }
    }

    @Deprecated
    public List<KaleoLog> getKaleoInstanceKaleoLogs(long kaleoInstanceId, List<Integer> logTypes, int start, int end, OrderByComparator<KaleoLog> orderByComparator) {
        if (logTypes == null || logTypes.isEmpty()) {
            return this.kaleoLogPersistence.findByKaleoInstanceId(kaleoInstanceId, start, end, orderByComparator);
        }
        DynamicQuery dynamicQuery = this.buildKaleoInstanceDynamicQuery(kaleoInstanceId, logTypes);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoLog> getKaleoInstanceKaleoLogs(long companyId, long kaleoInstanceId, List<Integer> logTypes, int start, int end, OrderByComparator<KaleoLog> orderByComparator) {
        return this.doSearch(companyId, HashMapBuilder.put((Object)"kaleoInstanceId", (Object)kaleoInstanceId).put((Object)"logTypes", this._toIntegerArraySupplier(logTypes)).build(), start, end, orderByComparator);
    }

    @Deprecated
    public int getKaleoInstanceKaleoLogsCount(long kaleoInstanceId, List<Integer> logTypes) {
        if (logTypes == null || logTypes.isEmpty()) {
            return this.kaleoLogPersistence.countByKaleoInstanceId(kaleoInstanceId);
        }
        DynamicQuery dynamicQuery = this.buildKaleoInstanceDynamicQuery(kaleoInstanceId, logTypes);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoInstanceKaleoLogsCount(long companyId, long kaleoInstanceId, List<Integer> logTypes) {
        return this.doSearchCount(companyId, HashMapBuilder.put((Object)"kaleoInstanceId", (Object)kaleoInstanceId).put((Object)"logTypes", this._toIntegerArraySupplier(logTypes)).build());
    }

    @Deprecated
    public List<KaleoLog> getKaleoTaskInstanceTokenKaleoLogs(long kaleoTaskInstanceTokenId, List<Integer> logTypes, int start, int end, OrderByComparator<KaleoLog> orderByComparator) {
        if (logTypes == null || logTypes.isEmpty()) {
            return this.kaleoLogPersistence.findByKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId, start, end, orderByComparator);
        }
        DynamicQuery dynamicQuery = this.buildKaleoTaskInstanceTokenDynamicQuery(kaleoTaskInstanceTokenId, logTypes);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoLog> getKaleoTaskInstanceTokenKaleoLogs(long companyId, long kaleoTaskInstanceTokenId, List<Integer> logTypes, int start, int end, OrderByComparator<KaleoLog> orderByComparator) {
        return this.doSearch(companyId, HashMapBuilder.put((Object)"kaleoTaskInstanceTokenId", (Object)kaleoTaskInstanceTokenId).put((Object)"logTypes", this._toIntegerArraySupplier(logTypes)).build(), start, end, orderByComparator);
    }

    @Deprecated
    public int getKaleoTaskInstanceTokenKaleoLogsCount(long kaleoTaskInstanceTokenId, List<Integer> logTypes) {
        if (logTypes == null || logTypes.isEmpty()) {
            return this.kaleoLogPersistence.countByKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId);
        }
        DynamicQuery dynamicQuery = this.buildKaleoTaskInstanceTokenDynamicQuery(kaleoTaskInstanceTokenId, logTypes);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoTaskInstanceTokenKaleoLogsCount(long companyId, long kaleoTaskInstanceTokenId, List<Integer> logTypes) {
        return this.doSearchCount(companyId, HashMapBuilder.put((Object)"kaleoTaskInstanceTokenId", (Object)kaleoTaskInstanceTokenId).put((Object)"logTypes", this._toIntegerArraySupplier(logTypes)).build());
    }

    protected void addLogTypesJunction(DynamicQuery dynamicQuery, List<Integer> logTypes) {
        Disjunction junction = RestrictionsFactoryUtil.disjunction();
        for (Integer logType : logTypes) {
            String logTypeString = KaleoLogUtil.convert((int)logType);
            if (Validator.isNull((String)logTypeString)) continue;
            Property property = PropertyFactoryUtil.forName((String)"type");
            junction.add(property.eq((Object)logTypeString));
        }
        dynamicQuery.add((Criterion)junction);
    }

    protected DynamicQuery buildKaleoInstanceDynamicQuery(long kaleoInstanceId, List<Integer> logTypes) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoLog.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"kaleoInstanceId");
        dynamicQuery.add(property.eq((Object)kaleoInstanceId));
        this.addLogTypesJunction(dynamicQuery, logTypes);
        return dynamicQuery;
    }

    protected DynamicQuery buildKaleoTaskInstanceTokenDynamicQuery(long kaleoTaskId, List<Integer> logTypes) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoLog.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"kaleoTaskInstanceTokenId");
        dynamicQuery.add(property.eq((Object)kaleoTaskId));
        this.addLogTypesJunction(dynamicQuery, logTypes);
        return dynamicQuery;
    }

    protected SearchContext buildSearchContext(long companyId, Map<String, Serializable> searchAttributes, int start, int end, OrderByComparator<KaleoLog> orderByComparator) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes(searchAttributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{-1L});
        searchContext.setStart(start);
        if (orderByComparator != null) {
            searchContext.setSorts(this.getSortsFromComparator(orderByComparator));
        }
        return searchContext;
    }

    protected KaleoLog createKaleoLog(KaleoInstanceToken kaleoInstanceToken, LogType logType, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoLogId = this.counterLocalService.increment();
        KaleoLog kaleoLog = this.kaleoLogPersistence.create(kaleoLogId);
        kaleoLog.setCompanyId(user.getCompanyId());
        kaleoLog.setUserId(user.getUserId());
        kaleoLog.setUserName(user.getFullName());
        kaleoLog.setCreateDate(date);
        kaleoLog.setModifiedDate(date);
        kaleoLog.setKaleoDefinitionId(kaleoInstanceToken.getKaleoDefinitionId());
        kaleoLog.setKaleoDefinitionVersionId(kaleoInstanceToken.getKaleoDefinitionVersionId());
        kaleoLog.setKaleoInstanceId(kaleoInstanceToken.getKaleoInstanceId());
        kaleoLog.setKaleoInstanceTokenId(kaleoInstanceToken.getKaleoInstanceTokenId());
        kaleoLog.setType(logType.name());
        return kaleoLog;
    }

    protected List<KaleoLog> doSearch(long companyId, Map<String, Serializable> searchAttributes, int start, int end, OrderByComparator<KaleoLog> orderByComparator) {
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoLog.class.getName());
            Hits hits = indexer.search(this.buildSearchContext(companyId, searchAttributes, start, end, orderByComparator));
            return Stream.of(hits.getDocs()).map(document -> GetterUtil.getLong((String)document.get("entryClassPK"))).map(arg_0 -> ((KaleoLogPersistence)this.kaleoLogPersistence).fetchByPrimaryKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return Collections.emptyList();
        }
    }

    protected int doSearchCount(long companyId, Map<String, Serializable> searchAttributes) {
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoLog.class.getName());
            return (int)indexer.searchCount(this.buildSearchContext(companyId, searchAttributes, -1, -1, null));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return 0;
        }
    }

    protected KaleoLog getPreviousLog(long kaleoInstanceTokenId, long kaleoNodeId, LogType logType) throws PortalException {
        List kaleoLogEntries = null;
        kaleoLogEntries = kaleoNodeId > 0L ? this.kaleoLogPersistence.findByKCN_KCPK_KITI_T(KaleoNode.class.getName(), kaleoNodeId, kaleoInstanceTokenId, logType.name()) : this.kaleoLogPersistence.findByKITI_T(kaleoInstanceTokenId, logType.name());
        if (!kaleoLogEntries.isEmpty()) {
            return (KaleoLog)kaleoLogEntries.get(0);
        }
        throw new NoSuchLogException();
    }

    protected Sort[] getSortsFromComparator(OrderByComparator<KaleoLog> orderByComparator) {
        if (orderByComparator == null) {
            return null;
        }
        return (Sort[])Stream.of(orderByComparator.getOrderByFields()).map(orderByFieldName -> {
            String fieldName = _fieldNameOrderByCols.getOrDefault(orderByFieldName, (String)orderByFieldName);
            return new Sort(fieldName, _fieldNameSortTypes.getOrDefault(fieldName, 3).intValue(), !orderByComparator.isAscending());
        }).toArray(Sort[]::new);
    }

    private static String _getSortableFieldName(String name, String type) {
        return Field.getSortableFieldName((String)StringBundler.concat((String[])new String[]{name, "_", type}));
    }

    private BaseMapBuilder.UnsafeSupplier<Serializable, Exception> _toIntegerArraySupplier(List<Integer> logTypes) {
        return () -> {
            if (ListUtil.isEmpty((List)logTypes)) {
                return null;
            }
            return logTypes.toArray(new Integer[0]);
        };
    }
}

