/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.Node;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.State;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.service.KaleoActionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNotificationLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoNodeLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoNode"}, service={AopService.class})
public class KaleoNodeLocalServiceImpl
extends KaleoNodeLocalServiceBaseImpl {
    @Reference
    private KaleoActionLocalService _kaleoActionLocalService;
    @Reference
    private KaleoNotificationLocalService _kaleoNotificationLocalService;
    @Reference
    private KaleoTimerLocalService _kaleoTimerLocalService;

    public KaleoNode addKaleoNode(long kaleoDefinitionId, long kaleoDefinitionVersionId, Node node, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoNodeId = this.counterLocalService.increment();
        KaleoNode kaleoNode = this.kaleoNodePersistence.create(kaleoNodeId);
        kaleoNode.setCompanyId(user.getCompanyId());
        kaleoNode.setUserId(user.getUserId());
        kaleoNode.setUserName(user.getFullName());
        kaleoNode.setCreateDate(date);
        kaleoNode.setModifiedDate(date);
        kaleoNode.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoNode.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoNode.setName(node.getName());
        kaleoNode.setMetadata(node.getMetadata());
        kaleoNode.setDescription(node.getDescription());
        NodeType nodeType = node.getNodeType();
        kaleoNode.setType(nodeType.name());
        boolean initial = false;
        boolean terminal = false;
        if (nodeType.equals((Object)NodeType.STATE)) {
            State state = (State)node;
            initial = state.isInitial();
            terminal = state.isTerminal();
        }
        kaleoNode.setInitial(initial);
        kaleoNode.setTerminal(terminal);
        kaleoNode = (KaleoNode)this.kaleoNodePersistence.update((BaseModel)kaleoNode);
        Set actions = node.getActions();
        for (Object action : actions) {
            this._kaleoActionLocalService.addKaleoAction(KaleoNode.class.getName(), kaleoNodeId, kaleoDefinitionId, kaleoDefinitionVersionId, node.getName(), (Action)action, serviceContext);
        }
        Set notifications = node.getNotifications();
        for (Notification notification : notifications) {
            this._kaleoNotificationLocalService.addKaleoNotification(KaleoNode.class.getName(), kaleoNodeId, kaleoDefinitionId, kaleoDefinitionVersionId, node.getName(), notification, serviceContext);
        }
        Set timers = node.getTimers();
        for (Timer timer : timers) {
            this._kaleoTimerLocalService.addKaleoTimer(KaleoNode.class.getName(), kaleoNodeId, kaleoDefinitionId, kaleoDefinitionVersionId, timer, serviceContext);
        }
        return kaleoNode;
    }

    public void deleteCompanyKaleoNodes(long companyId) {
        this.kaleoNodePersistence.removeByCompanyId(companyId);
        this._kaleoActionLocalService.deleteCompanyKaleoActions(companyId);
        this._kaleoNotificationLocalService.deleteCompanyKaleoNotifications(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoNodes(long kaleoDefinitionVersionId) {
        this.kaleoNodePersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        this._kaleoActionLocalService.deleteKaleoDefinitionVersionKaleoActions(kaleoDefinitionVersionId);
        this._kaleoNotificationLocalService.deleteKaleoDefinitionVersionKaleoNotifications(kaleoDefinitionVersionId);
    }

    public List<KaleoNode> getKaleoDefinitionVersionKaleoNodes(long kaleoDefinitionVersionId) {
        return this.kaleoNodePersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }
}

