/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.AddressRecipient;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import com.liferay.portal.workflow.kaleo.definition.Recipient;
import com.liferay.portal.workflow.kaleo.definition.RecipientType;
import com.liferay.portal.workflow.kaleo.definition.RoleRecipient;
import com.liferay.portal.workflow.kaleo.definition.ScriptLanguage;
import com.liferay.portal.workflow.kaleo.definition.ScriptRecipient;
import com.liferay.portal.workflow.kaleo.definition.UserRecipient;
import com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient;
import com.liferay.portal.workflow.kaleo.runtime.util.RoleUtil;
import com.liferay.portal.workflow.kaleo.service.base.KaleoNotificationRecipientLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoNotificationRecipient"}, service={AopService.class})
public class KaleoNotificationRecipientLocalServiceImpl
extends KaleoNotificationRecipientLocalServiceBaseImpl {
    public KaleoNotificationRecipient addKaleoNotificationRecipient(long kaleoDefinitionId, long kaleoDefinitionVersionId, long kaleoNotificationId, Recipient recipient, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoNotificationRecipientId = this.counterLocalService.increment();
        KaleoNotificationRecipient kaleoNotificationRecipient = this.kaleoNotificationRecipientPersistence.create(kaleoNotificationRecipientId);
        kaleoNotificationRecipient.setCompanyId(user.getCompanyId());
        kaleoNotificationRecipient.setUserId(user.getUserId());
        kaleoNotificationRecipient.setUserName(user.getFullName());
        kaleoNotificationRecipient.setCreateDate(date);
        kaleoNotificationRecipient.setModifiedDate(date);
        kaleoNotificationRecipient.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoNotificationRecipient.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoNotificationRecipient.setKaleoNotificationId(kaleoNotificationId);
        NotificationReceptionType notificationReceptionType = recipient.getNotificationReceptionType();
        kaleoNotificationRecipient.setNotificationReceptionType(notificationReceptionType.getValue());
        this.setRecipient(kaleoNotificationRecipient, recipient, serviceContext);
        return (KaleoNotificationRecipient)this.kaleoNotificationRecipientPersistence.update((BaseModel)kaleoNotificationRecipient);
    }

    public void deleteCompanyKaleoNotificationRecipients(long companyId) {
        this.kaleoNotificationRecipientPersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoNotificationRecipients(long kaleoDefinitionVersionId) {
        this.kaleoNotificationRecipientPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public List<KaleoNotificationRecipient> getKaleoNotificationRecipients(long kaleoNotificationId) {
        return this.kaleoNotificationRecipientPersistence.findByKaleoNotificationId(kaleoNotificationId);
    }

    protected void setRecipient(KaleoNotificationRecipient kaleoNotificationRecipient, Recipient recipient, ServiceContext serviceContext) throws PortalException {
        RecipientType recipientType = recipient.getRecipientType();
        kaleoNotificationRecipient.setRecipientClassName(recipientType.getValue());
        if (recipientType.equals((Object)RecipientType.ADDRESS)) {
            AddressRecipient addressRecipient = (AddressRecipient)recipient;
            kaleoNotificationRecipient.setAddress(addressRecipient.getAddress());
        } else if (recipientType.equals((Object)RecipientType.ROLE)) {
            RoleRecipient roleRecipient = (RoleRecipient)recipient;
            int roleType = 0;
            Role role = null;
            if (Validator.isNotNull((String)roleRecipient.getRoleName())) {
                roleType = RoleUtil.getRoleType((String)roleRecipient.getRoleType());
                role = RoleUtil.getRole((String)roleRecipient.getRoleName(), (int)roleType, (boolean)roleRecipient.isAutoCreate(), (ServiceContext)serviceContext);
            } else {
                role = this.roleLocalService.getRole(roleRecipient.getRoleId());
                roleType = role.getType();
            }
            kaleoNotificationRecipient.setRecipientClassPK(role.getClassPK());
            kaleoNotificationRecipient.setRecipientRoleType(roleType);
        } else if (recipientType.equals((Object)RecipientType.SCRIPT)) {
            ScriptRecipient scriptRecipient = (ScriptRecipient)recipient;
            kaleoNotificationRecipient.setRecipientScript(scriptRecipient.getScript());
            ScriptLanguage scriptLanguage = scriptRecipient.getScriptLanguage();
            kaleoNotificationRecipient.setRecipientScriptLanguage(scriptLanguage.getValue());
            kaleoNotificationRecipient.setRecipientScriptContexts(scriptRecipient.getScriptRequiredContexts());
        } else if (recipientType.equals((Object)RecipientType.USER)) {
            UserRecipient userRecipient = (UserRecipient)recipient;
            User user = null;
            if (userRecipient.getUserId() > 0L) {
                user = this.userLocalService.getUser(userRecipient.getUserId());
            } else if (Validator.isNotNull((String)userRecipient.getScreenName())) {
                user = this.userLocalService.getUserByScreenName(serviceContext.getCompanyId(), userRecipient.getScreenName());
            } else if (Validator.isNotNull((String)userRecipient.getEmailAddress())) {
                user = this.userLocalService.getUserByEmailAddress(serviceContext.getCompanyId(), userRecipient.getEmailAddress());
            }
            if (user != null) {
                kaleoNotificationRecipient.setRecipientClassPK(user.getUserId());
            }
        }
    }
}

