/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskForm;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskFormInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.form.FormValueProcessor;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskFormLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskFormInstanceLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTaskFormInstance"}, service={AopService.class})
public class KaleoTaskFormInstanceLocalServiceImpl
extends KaleoTaskFormInstanceLocalServiceBaseImpl {
    @Reference
    private FormValueProcessor _formValueProcessor;
    @Reference
    private KaleoTaskFormLocalService _kaleoTaskFormLocalService;

    public KaleoTaskFormInstance addKaleoTaskFormInstance(long groupId, long kaleoTaskFormId, String formValues, KaleoTaskInstanceToken kaleoTaskInstanceToken, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoTaskFormInstanceId = this.counterLocalService.increment();
        KaleoTaskFormInstance kaleoTaskFormInstance = this.kaleoTaskFormInstancePersistence.create(kaleoTaskFormInstanceId);
        kaleoTaskFormInstance.setGroupId(groupId);
        kaleoTaskFormInstance.setCompanyId(user.getCompanyId());
        kaleoTaskFormInstance.setUserId(user.getUserId());
        kaleoTaskFormInstance.setUserName(user.getFullName());
        kaleoTaskFormInstance.setCreateDate(date);
        kaleoTaskFormInstance.setModifiedDate(date);
        kaleoTaskFormInstance.setKaleoDefinitionId(kaleoTaskInstanceToken.getKaleoDefinitionId());
        kaleoTaskFormInstance.setKaleoDefinitionVersionId(kaleoTaskInstanceToken.getKaleoDefinitionVersionId());
        kaleoTaskFormInstance.setKaleoInstanceId(kaleoTaskInstanceToken.getKaleoInstanceId());
        kaleoTaskFormInstance.setKaleoTaskId(kaleoTaskInstanceToken.getKaleoTaskId());
        kaleoTaskFormInstance.setKaleoTaskInstanceTokenId(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        kaleoTaskFormInstance.setKaleoTaskFormId(kaleoTaskFormId);
        KaleoTaskForm kaleoTaskForm = this._kaleoTaskFormLocalService.getKaleoTaskForm(kaleoTaskFormId);
        if (Validator.isNotNull((String)kaleoTaskForm.getFormDefinition())) {
            kaleoTaskFormInstance.setFormValues(formValues);
        } else {
            kaleoTaskFormInstance = this._formValueProcessor.processFormValues(kaleoTaskForm, kaleoTaskFormInstance, formValues, serviceContext);
        }
        return (KaleoTaskFormInstance)this.kaleoTaskFormInstancePersistence.update((BaseModel)kaleoTaskFormInstance);
    }

    public int countKaleoTaskFormInstanceByKaleoTaskId(long kaleoTaskId) {
        return this.kaleoTaskFormInstancePersistence.countByKaleoTaskId(kaleoTaskId);
    }

    public void deleteCompanyKaleoTaskFormInstances(long companyId) {
        this.kaleoTaskFormInstancePersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskFormInstances(long kaleoDefinitionVersionId) {
        this.kaleoTaskFormInstancePersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public void deleteKaleoInstanceKaleoTaskFormInstances(long kaleoInstanceId) {
        this.kaleoTaskFormInstancePersistence.removeByKaleoInstanceId(kaleoInstanceId);
    }

    public void deleteKaleoTaskInstanceTokenKaleoTaskFormInstances(long kaleoTaskInstanceTokenId) {
        this.kaleoTaskFormInstancePersistence.removeByKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId);
    }

    public KaleoTaskFormInstance fetchKaleoTaskFormKaleoTaskFormInstance(long kaleoTaskFormId) {
        return this.kaleoTaskFormInstancePersistence.fetchByKaleoTaskFormId(kaleoTaskFormId);
    }

    public KaleoTaskFormInstance getKaleoTaskFormKaleoTaskFormInstance(long kaleoTaskFormId) throws PortalException {
        return this.kaleoTaskFormInstancePersistence.findByKaleoTaskFormId(kaleoTaskFormId);
    }

    public List<KaleoTaskFormInstance> getKaleoTaskKaleoTaskFormInstances(long kaleoTaskId) {
        return this.kaleoTaskFormInstancePersistence.findByKaleoTaskId(kaleoTaskId);
    }
}

