/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignment;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskFormInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskInstanceTokenLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenPersistence;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoTaskInstanceTokenQuery;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken"}, service={AopService.class})
public class KaleoTaskInstanceTokenLocalServiceImpl
extends KaleoTaskInstanceTokenLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KaleoTaskInstanceTokenLocalServiceImpl.class);
    private static final Map<String, String> _fieldNameOrderByCols = HashMapBuilder.put((Object)"createDate", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("createDate", "Number")).put((Object)"userId", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("userId", "Number")).put((Object)"completed", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("completed", "String")).put((Object)"completionDate", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("completionDate", "Number")).put((Object)"dueDate", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("dueDate", "Number")).put((Object)"kaleoInstanceId", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("kaleoInstanceId", "Number")).put((Object)"kaleoTaskId", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("kaleoTaskId", "Number")).put((Object)"kaleoTaskInstanceTokenId", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("kaleoTaskInstanceTokenId", "Number")).put((Object)"modifiedDate", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("modified", "Number")).put((Object)"name", (Object)KaleoTaskInstanceTokenLocalServiceImpl._getSortableFieldName("taskName", "String")).build();
    private static final Map<String, Integer> _fieldNameSortTypes = HashMapBuilder.put((Object)"createDate", (Object)6).put((Object)"modified", (Object)6).put((Object)"completionDate", (Object)6).put((Object)"dueDate", (Object)6).build();
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;
    @Reference
    private KaleoTaskFormInstanceLocalService _kaleoTaskFormInstanceLocalService;
    @Reference
    private KaleoTimerInstanceTokenLocalService _kaleoTimerInstanceTokenLocalService;
    @Reference
    private Staging _staging;

    @Indexable(type=IndexableType.REINDEX)
    public KaleoTaskInstanceToken addKaleoTaskInstanceToken(long kaleoInstanceTokenId, long kaleoTaskId, String kaleoTaskName, Collection<KaleoTaskAssignment> kaleoTaskAssignments, Date dueDate, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = this.kaleoInstanceTokenPersistence.findByPrimaryKey(kaleoInstanceTokenId);
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoTaskInstanceTokenId = this.counterLocalService.increment();
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.create(kaleoTaskInstanceTokenId);
        long groupId = this._staging.getLiveGroupId(serviceContext.getScopeGroupId());
        kaleoTaskInstanceToken.setGroupId(groupId);
        kaleoTaskInstanceToken.setCompanyId(user.getCompanyId());
        kaleoTaskInstanceToken.setUserId(user.getUserId());
        kaleoTaskInstanceToken.setUserName(user.getFullName());
        kaleoTaskInstanceToken.setCreateDate(date);
        kaleoTaskInstanceToken.setModifiedDate(date);
        kaleoTaskInstanceToken.setKaleoDefinitionId(kaleoInstanceToken.getKaleoDefinitionId());
        kaleoTaskInstanceToken.setKaleoDefinitionVersionId(kaleoInstanceToken.getKaleoDefinitionVersionId());
        kaleoTaskInstanceToken.setKaleoInstanceId(kaleoInstanceToken.getKaleoInstanceId());
        kaleoTaskInstanceToken.setKaleoInstanceTokenId(kaleoInstanceTokenId);
        kaleoTaskInstanceToken.setDueDate(dueDate);
        kaleoTaskInstanceToken.setKaleoTaskId(kaleoTaskId);
        kaleoTaskInstanceToken.setKaleoTaskName(kaleoTaskName);
        if (workflowContext != null) {
            kaleoTaskInstanceToken.setClassName((String)((Object)workflowContext.get("entryClassName")));
            if (workflowContext.containsKey("entryClassPK")) {
                kaleoTaskInstanceToken.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
            }
        }
        kaleoTaskInstanceToken.setCompleted(false);
        kaleoTaskInstanceToken.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        kaleoTaskInstanceToken = (KaleoTaskInstanceToken)this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this._kaleoTaskAssignmentInstanceLocalService.addTaskAssignmentInstances(kaleoTaskInstanceToken, kaleoTaskAssignments, workflowContext, serviceContext);
        return kaleoTaskInstanceToken;
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoTaskInstanceToken assignKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId, Collection<KaleoTaskAssignment> kaleoTaskAssignments, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setModifiedDate(new Date());
        kaleoTaskInstanceToken.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        kaleoTaskInstanceToken = (KaleoTaskInstanceToken)this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this._kaleoTaskAssignmentInstanceLocalService.assignKaleoTaskAssignmentInstances(kaleoTaskInstanceToken, kaleoTaskAssignments, workflowContext, serviceContext);
        return kaleoTaskInstanceToken;
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoTaskInstanceToken assignKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId, String assigneeClassName, long assigneeClassPK, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setModifiedDate(new Date());
        kaleoTaskInstanceToken.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        kaleoTaskInstanceToken = (KaleoTaskInstanceToken)this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this._kaleoTaskAssignmentInstanceLocalService.assignKaleoTaskAssignmentInstance(kaleoTaskInstanceToken, assigneeClassName, assigneeClassPK, serviceContext);
        return kaleoTaskInstanceToken;
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoTaskInstanceToken completeKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setCompletionUserId(serviceContext.getUserId());
        kaleoTaskInstanceToken.setCompleted(true);
        kaleoTaskInstanceToken.setCompletionDate(new Date());
        kaleoTaskInstanceToken = (KaleoTaskInstanceToken)this.kaleoTaskInstanceTokenPersistence.update((BaseModel)kaleoTaskInstanceToken);
        this._kaleoTaskAssignmentInstanceLocalService.completeKaleoTaskInstanceToken(kaleoTaskInstanceTokenId, serviceContext);
        this._kaleoTimerInstanceTokenLocalService.completeKaleoTimerInstanceTokens(kaleoTaskInstanceToken.getKaleoInstanceTokenId(), serviceContext);
        return kaleoTaskInstanceToken;
    }

    public void deleteCompanyKaleoTaskInstanceTokens(long companyId) {
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : this.kaleoTaskInstanceTokenPersistence.findByCompanyId(companyId)) {
            this.kaleoTaskInstanceTokenLocalService.deleteKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        }
        this._kaleoTaskAssignmentInstanceLocalService.deleteCompanyKaleoTaskAssignmentInstances(companyId);
        this._kaleoTaskFormInstanceLocalService.deleteCompanyKaleoTaskFormInstances(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskInstanceTokens(long kaleoDefinitionVersionId) {
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : this.kaleoTaskInstanceTokenPersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId)) {
            this.kaleoTaskInstanceTokenLocalService.deleteKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        }
        this._kaleoTaskAssignmentInstanceLocalService.deleteKaleoDefinitionVersionKaleoTaskAssignmentInstances(kaleoDefinitionVersionId);
        this._kaleoTaskFormInstanceLocalService.deleteKaleoDefinitionVersionKaleoTaskFormInstances(kaleoDefinitionVersionId);
    }

    public void deleteKaleoInstanceKaleoTaskInstanceTokens(long kaleoInstanceId) {
        for (KaleoTaskInstanceToken kaleoTaskInstanceToken : this.kaleoTaskInstanceTokenPersistence.findByKaleoInstanceId(kaleoInstanceId)) {
            this.kaleoTaskInstanceTokenLocalService.deleteKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        }
        this._kaleoTaskAssignmentInstanceLocalService.deleteKaleoInstanceKaleoTaskAssignmentInstances(kaleoInstanceId);
        this._kaleoTaskFormInstanceLocalService.deleteKaleoInstanceKaleoTaskFormInstances(kaleoInstanceId);
    }

    @Override
    public KaleoTaskInstanceToken deleteKaleoTaskInstanceToken(long kaleoTaskInstanceTokenId) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.remove(kaleoTaskInstanceTokenId);
        this._kaleoTaskAssignmentInstanceLocalService.deleteKaleoTaskAssignmentInstances(kaleoTaskInstanceToken);
        this._kaleoTaskFormInstanceLocalService.deleteKaleoTaskInstanceTokenKaleoTaskFormInstances(kaleoTaskInstanceTokenId);
        return kaleoTaskInstanceToken;
    }

    public List<KaleoTaskInstanceToken> getCompanyKaleoTaskInstanceTokens(long companyId, int start, int end) {
        return this.kaleoTaskInstanceTokenPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyKaleoTaskInstanceTokensCount(long companyId) {
        return this.kaleoTaskInstanceTokenPersistence.countByCompanyId(companyId);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(completed, serviceContext);
        return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(List<Long> roleIds, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setRoleIds(roleIds);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(long kaleoInstanceId, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        long userId = serviceContext.getUserId();
        if (userId == 0L) {
            DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoInstanceId, completed, serviceContext);
            return this.dynamicQuery(dynamicQuery, start, end, orderByComparator);
        }
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(User.class.getName());
        kaleoTaskInstanceTokenQuery.setAssigneeClassPKs(this.getAssigneeClassPKs(serviceContext.getUserId()));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setKaleoInstanceIds(this.getKaleoInstanceIds(kaleoInstanceId));
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public KaleoTaskInstanceToken getKaleoTaskInstanceTokens(long kaleoInstanceId, long kaleoTaskId) throws PortalException {
        return this.kaleoTaskInstanceTokenPersistence.findByKII_KTI(kaleoInstanceId, kaleoTaskId);
    }

    public List<KaleoTaskInstanceToken> getKaleoTaskInstanceTokens(String assigneeClassName, long assigneeClassPK, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(assigneeClassName);
        kaleoTaskInstanceTokenQuery.setAssigneeClassPKs(this.getAssigneeClassPKs(assigneeClassPK));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setEnd(end);
        kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
        kaleoTaskInstanceTokenQuery.setStart(start);
        return this.kaleoTaskInstanceTokenFinder.findKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = this.buildDynamicQuery(completed, serviceContext);
        return (int)this.dynamicQueryCount(dynamicQuery);
    }

    public int getKaleoTaskInstanceTokensCount(List<Long> roleIds, Boolean completed, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(Role.class.getName());
        kaleoTaskInstanceTokenQuery.setRoleIds(roleIds);
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(long kaleoInstanceId, Boolean completed, ServiceContext serviceContext) {
        long userId = serviceContext.getUserId();
        if (userId == 0L) {
            DynamicQuery dynamicQuery = this.buildDynamicQuery(kaleoInstanceId, completed, serviceContext);
            return (int)this.dynamicQueryCount(dynamicQuery);
        }
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(User.class.getName());
        kaleoTaskInstanceTokenQuery.setAssigneeClassPKs(this.getAssigneeClassPKs(serviceContext.getUserId()));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setKaleoInstanceIds(this.getKaleoInstanceIds(kaleoInstanceId));
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public int getKaleoTaskInstanceTokensCount(String assigneeClassName, long assigneeClassPK, Boolean completed, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(assigneeClassName);
        kaleoTaskInstanceTokenQuery.setAssigneeClassPKs(this.getAssigneeClassPKs(assigneeClassPK));
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        return this.kaleoTaskInstanceTokenFinder.countKaleoTaskInstanceTokens(kaleoTaskInstanceTokenQuery);
    }

    public List<KaleoTaskInstanceToken> getSubmittingUserKaleoTaskInstanceTokens(long userId, Boolean completed, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        if (completed == null) {
            return this.kaleoTaskInstanceTokenPersistence.findByC_U(serviceContext.getCompanyId(), userId, start, end, orderByComparator);
        }
        return this.kaleoTaskInstanceTokenPersistence.findByC_U_C(serviceContext.getCompanyId(), userId, completed.booleanValue(), start, end, orderByComparator);
    }

    public int getSubmittingUserKaleoTaskInstanceTokensCount(long userId, Boolean completed, ServiceContext serviceContext) {
        if (completed == null) {
            return this.kaleoTaskInstanceTokenPersistence.countByC_U(serviceContext.getCompanyId(), userId);
        }
        return this.kaleoTaskInstanceTokenPersistence.countByC_U_C(serviceContext.getCompanyId(), userId, completed.booleanValue());
    }

    public boolean hasPendingKaleoTaskForms(long kaleoTaskInstanceTokenId) throws PortalException {
        int kaleoTaskFormInstancesCount;
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        int kaleoTaskFormsCount = this.kaleoTaskFormPersistence.countByKaleoTaskId(kaleoTaskInstanceToken.getKaleoTaskId());
        return kaleoTaskFormsCount > (kaleoTaskFormInstancesCount = this.kaleoTaskFormInstancePersistence.countByKaleoTaskInstanceTokenId(kaleoTaskInstanceTokenId));
    }

    public List<KaleoTaskInstanceToken> search(String keywords, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(keywords, keywords, null, null, null, completed, searchByUserRoles, false, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String taskName, String assetType, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(null, taskName, this.getAssetTypes(assetType), assetPrimaryKeys, dueDateGT, dueDateLT, completed, searchByUserRoles, andOperator, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String assetTitle, String taskName, String[] assetTypes, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(assetTitle, this.getTaskNames(taskName), assetTypes, assetPrimaryKeys, null, dueDateGT, dueDateLT, completed, null, searchByUserRoles, andOperator, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(keywords, keywords, assetTypes, null, null, null, completed, searchByUserRoles, false, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, Long[] assigneeClassPKs, Date dueDateGT, Date dueDateLT, Boolean completed, Long[] kaleoInstanceIds, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        return this.search(assetTitle, taskNames, assetTypes, assetPrimaryKeys, null, assigneeClassPKs, dueDateGT, dueDateLT, completed, null, kaleoInstanceIds, searchByUserRoles, andOperator, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoTaskInstanceToken> search(String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeClassPKs, Date dueDateGT, Date dueDateLT, Boolean completed, Long kaleoDefinitionId, Long[] kaleoInstanceIds, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        try {
            BaseModelSearchResult<KaleoTaskInstanceToken> baseModelSearchResult = this.searchKaleoTaskInstanceTokens(assetTitle, taskNames, assetTypes, assetPrimaryKeys, assigneeClassName, assigneeClassPKs, dueDateGT, dueDateLT, completed, kaleoDefinitionId, kaleoInstanceIds, searchByUserRoles, andOperator, start, end, orderByComparator, serviceContext);
            return baseModelSearchResult.getBaseModels();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return Collections.emptyList();
        }
    }

    public int searchCount(long kaleoInstanceId, Boolean completed, Boolean searchByUserRoles, ServiceContext serviceContext) {
        return this.searchCount(kaleoInstanceId, null, null, null, null, null, null, completed, searchByUserRoles, false, serviceContext);
    }

    public int searchCount(Long kaleoInstanceId, String assetTitle, String taskName, String[] assetTypes, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, ServiceContext serviceContext) {
        return this.searchCount(assetTitle, this.getTaskNames(taskName), assetTypes, assetPrimaryKeys, null, dueDateGT, dueDateLT, completed, this.getKaleoInstanceIds(kaleoInstanceId), searchByUserRoles, andOperator, serviceContext);
    }

    public int searchCount(String keywords, Boolean completed, Boolean searchByUserRoles, ServiceContext serviceContext) {
        return this.searchCount(keywords, keywords, null, null, null, completed, searchByUserRoles, false, serviceContext);
    }

    public int searchCount(String taskName, String assetType, Long[] assetPrimaryKeys, Date dueDateGT, Date dueDateLT, Boolean completed, Boolean searchByUserRoles, boolean andOperator, ServiceContext serviceContext) {
        return this.searchCount(null, null, taskName, this.getAssetTypes(assetType), assetPrimaryKeys, dueDateGT, dueDateLT, completed, searchByUserRoles, andOperator, serviceContext);
    }

    public int searchCount(String keywords, String[] assetTypes, Boolean completed, Boolean searchByUserRoles, ServiceContext serviceContext) {
        return this.searchCount(null, keywords, keywords, assetTypes, null, null, null, completed, searchByUserRoles, false, serviceContext);
    }

    public int searchCount(String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, Long[] assigneeClassPKs, Date dueDateGT, Date dueDateLT, Boolean completed, Long[] kaleoInstanceIds, Boolean searchByUserRoles, boolean andOperator, ServiceContext serviceContext) {
        return this.searchCount(assetTitle, taskNames, assetTypes, assetPrimaryKeys, null, assigneeClassPKs, dueDateGT, dueDateLT, completed, null, kaleoInstanceIds, searchByUserRoles, andOperator, serviceContext);
    }

    public int searchCount(String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeClassPKs, Date dueDateGT, Date dueDateLT, Boolean completed, Long kaleoDefinitionId, Long[] kaleoInstanceIds, Boolean searchByUserRoles, boolean andOperator, ServiceContext serviceContext) {
        KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
        kaleoTaskInstanceTokenQuery.setAndOperator(andOperator);
        kaleoTaskInstanceTokenQuery.setAssetTitle(assetTitle);
        kaleoTaskInstanceTokenQuery.setAssetTypes(assetTypes);
        kaleoTaskInstanceTokenQuery.setAssetPrimaryKeys(assetPrimaryKeys);
        kaleoTaskInstanceTokenQuery.setAssigneeClassName(assigneeClassName);
        kaleoTaskInstanceTokenQuery.setAssigneeClassPKs(assigneeClassPKs);
        kaleoTaskInstanceTokenQuery.setCompleted(completed);
        kaleoTaskInstanceTokenQuery.setDueDateGT(dueDateGT);
        kaleoTaskInstanceTokenQuery.setDueDateLT(dueDateLT);
        kaleoTaskInstanceTokenQuery.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoTaskInstanceTokenQuery.setKaleoInstanceIds(kaleoInstanceIds);
        kaleoTaskInstanceTokenQuery.setSearchByUserRoles(searchByUserRoles);
        kaleoTaskInstanceTokenQuery.setTaskNames(taskNames);
        return this.doSearchCount(HashMapBuilder.put((Object)"kaleoTaskInstanceTokenQuery", (Object)kaleoTaskInstanceTokenQuery).build(), serviceContext);
    }

    public BaseModelSearchResult<KaleoTaskInstanceToken> searchKaleoTaskInstanceTokens(String assetTitle, String[] taskNames, String[] assetTypes, Long[] assetPrimaryKeys, String assigneeClassName, Long[] assigneeClassPKs, Date dueDateGT, Date dueDateLT, Boolean completed, Long kaleoDefinitionId, Long[] kaleoInstanceIds, Boolean searchByUserRoles, boolean andOperator, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) throws PortalException {
        Hits hits = this.doSearch(HashMapBuilder.put((Object)"kaleoTaskInstanceTokenQuery", () -> {
            KaleoTaskInstanceTokenQuery kaleoTaskInstanceTokenQuery = new KaleoTaskInstanceTokenQuery(serviceContext);
            kaleoTaskInstanceTokenQuery.setAndOperator(andOperator);
            kaleoTaskInstanceTokenQuery.setAssetTitle(assetTitle);
            kaleoTaskInstanceTokenQuery.setAssetTypes(assetTypes);
            kaleoTaskInstanceTokenQuery.setAssetPrimaryKeys(assetPrimaryKeys);
            kaleoTaskInstanceTokenQuery.setAssigneeClassName(assigneeClassName);
            kaleoTaskInstanceTokenQuery.setAssigneeClassPKs(assigneeClassPKs);
            kaleoTaskInstanceTokenQuery.setCompleted(completed);
            kaleoTaskInstanceTokenQuery.setDueDateGT(dueDateGT);
            kaleoTaskInstanceTokenQuery.setDueDateLT(dueDateLT);
            kaleoTaskInstanceTokenQuery.setEnd(end);
            kaleoTaskInstanceTokenQuery.setKaleoDefinitionId(kaleoDefinitionId);
            kaleoTaskInstanceTokenQuery.setKaleoInstanceIds(kaleoInstanceIds);
            kaleoTaskInstanceTokenQuery.setOrderByComparator(orderByComparator);
            kaleoTaskInstanceTokenQuery.setSearchByUserRoles(searchByUserRoles);
            kaleoTaskInstanceTokenQuery.setStart(start);
            kaleoTaskInstanceTokenQuery.setTaskNames(taskNames);
            return kaleoTaskInstanceTokenQuery;
        }).build(), start, end, orderByComparator, serviceContext);
        return new BaseModelSearchResult(Stream.of(hits.getDocs()).map(document -> GetterUtil.getLong((String)document.get("entryClassPK"))).map(arg_0 -> ((KaleoTaskInstanceTokenPersistence)this.kaleoTaskInstanceTokenPersistence).fetchByPrimaryKey(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()), hits.getLength());
    }

    public KaleoTaskInstanceToken updateDueDate(long kaleoTaskInstanceTokenId, Date dueDate, ServiceContext serviceContext) throws PortalException {
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this.kaleoTaskInstanceTokenPersistence.findByPrimaryKey(kaleoTaskInstanceTokenId);
        kaleoTaskInstanceToken.setModifiedDate(new Date());
        if (dueDate != null) {
            Calendar cal = CalendarFactoryUtil.getCalendar((Locale)LocaleUtil.getDefault());
            cal.setTime(dueDate);
            kaleoTaskInstanceToken.setDueDate(cal.getTime());
        }
        return this.kaleoTaskInstanceTokenLocalService.updateKaleoTaskInstanceToken(kaleoTaskInstanceToken);
    }

    protected void addCompletedCriterion(DynamicQuery dynamicQuery, Boolean completed) {
        if (completed == null) {
            return;
        }
        Property property = PropertyFactoryUtil.forName((String)"completed");
        dynamicQuery.add(property.eq((Object)completed));
    }

    protected DynamicQuery buildDynamicQuery(Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(property.eq((Object)serviceContext.getCompanyId()));
        this.addCompletedCriterion(dynamicQuery, completed);
        return dynamicQuery;
    }

    protected DynamicQuery buildDynamicQuery(long kaleoInstanceId, Boolean completed, ServiceContext serviceContext) {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(KaleoTaskInstanceToken.class, (ClassLoader)this.getClassLoader());
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)serviceContext.getCompanyId()));
        Property kaleoInstanceIdProperty = PropertyFactoryUtil.forName((String)"kaleoInstanceId");
        dynamicQuery.add(kaleoInstanceIdProperty.eq((Object)kaleoInstanceId));
        this.addCompletedCriterion(dynamicQuery, completed);
        return dynamicQuery;
    }

    protected SearchContext buildSearchContext(Map<String, Serializable> searchAttributes, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes(searchAttributes);
        searchContext.setCompanyId(serviceContext.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{-1L});
        searchContext.setStart(start);
        if (orderByComparator != null) {
            searchContext.setSorts(this.getSortsFromComparator(orderByComparator));
        }
        searchContext.setUserId(serviceContext.getUserId());
        return searchContext;
    }

    protected Hits doSearch(Map<String, Serializable> searchAttributes, int start, int end, OrderByComparator<KaleoTaskInstanceToken> orderByComparator, ServiceContext serviceContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoTaskInstanceToken.class.getName());
        return indexer.search(this.buildSearchContext(searchAttributes, start, end, orderByComparator, serviceContext));
    }

    protected int doSearchCount(Map<String, Serializable> searchAttributes, ServiceContext serviceContext) {
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoTaskInstanceToken.class.getName());
            return (int)indexer.searchCount(this.buildSearchContext(searchAttributes, -1, -1, null, serviceContext));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return 0;
        }
    }

    protected String[] getAssetTypes(String assetType) {
        if (Validator.isNull((String)assetType)) {
            return null;
        }
        return new String[]{assetType};
    }

    protected Long[] getAssigneeClassPKs(Long assigneeClassPK) {
        if (Validator.isNull((Long)assigneeClassPK)) {
            return null;
        }
        return new Long[]{assigneeClassPK};
    }

    protected Long[] getKaleoInstanceIds(Long kaleoInstanceId) {
        if (Validator.isNull((Long)kaleoInstanceId)) {
            return null;
        }
        return new Long[]{kaleoInstanceId};
    }

    protected Sort[] getSortsFromComparator(OrderByComparator<KaleoTaskInstanceToken> orderByComparator) {
        if (orderByComparator == null) {
            return null;
        }
        return (Sort[])Stream.of(orderByComparator.getOrderByFields()).map(orderByFieldName -> {
            String fieldName = _fieldNameOrderByCols.getOrDefault(orderByFieldName, (String)orderByFieldName);
            int sortType = _fieldNameSortTypes.getOrDefault(fieldName, 3);
            boolean ascending = orderByComparator.isAscending();
            if (Objects.equals(orderByFieldName, "completed")) {
                ascending = true;
            }
            return new Sort(fieldName, sortType, !ascending);
        }).toArray(Sort[]::new);
    }

    protected String[] getTaskNames(String taskName) {
        if (Validator.isNull((String)taskName)) {
            return null;
        }
        return new String[]{taskName};
    }

    private static String _getSortableFieldName(String name, String type) {
        return Field.getSortableFieldName((String)StringBundler.concat((String[])new String[]{name, "_", type}));
    }
}

