/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.Task;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskFormLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskLocalServiceBaseImpl;
import java.util.Date;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTask"}, service={AopService.class})
public class KaleoTaskLocalServiceImpl
extends KaleoTaskLocalServiceBaseImpl {
    @Reference
    private KaleoTaskAssignmentLocalService _kaleoTaskAssignmentLocalService;
    @Reference
    private KaleoTaskFormLocalService _kaleoTaskFormLocalService;

    public KaleoTask addKaleoTask(long kaleoDefinitionId, long kaleoDefinitionVersionId, long kaleoNodeId, Task task, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoTaskId = this.counterLocalService.increment();
        KaleoTask kaleoTask = this.kaleoTaskPersistence.create(kaleoTaskId);
        kaleoTask.setCompanyId(user.getCompanyId());
        kaleoTask.setUserId(user.getUserId());
        kaleoTask.setUserName(user.getFullName());
        kaleoTask.setCreateDate(date);
        kaleoTask.setModifiedDate(date);
        kaleoTask.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoTask.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoTask.setKaleoNodeId(kaleoNodeId);
        kaleoTask.setName(task.getName());
        kaleoTask.setDescription(task.getDescription());
        kaleoTask = (KaleoTask)this.kaleoTaskPersistence.update((BaseModel)kaleoTask);
        Set assignments = task.getAssignments();
        for (Assignment assignment : assignments) {
            this._kaleoTaskAssignmentLocalService.addKaleoTaskAssignment(KaleoTask.class.getName(), kaleoTaskId, kaleoDefinitionId, kaleoDefinitionVersionId, assignment, serviceContext);
        }
        Set taskForms = task.getTaskForms();
        for (TaskForm taskForm : taskForms) {
            this._kaleoTaskFormLocalService.addKaleoTaskForm(kaleoDefinitionId, kaleoDefinitionVersionId, kaleoNodeId, kaleoTask, taskForm, serviceContext);
        }
        return kaleoTask;
    }

    public void deleteCompanyKaleoTasks(long companyId) {
        this.kaleoTaskPersistence.removeByCompanyId(companyId);
        this._kaleoTaskAssignmentLocalService.deleteCompanyKaleoTaskAssignments(companyId);
        this._kaleoTaskFormLocalService.deleteCompanyKaleoTaskForms(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTasks(long kaleoDefinitionVersionId) {
        this.kaleoTaskPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        this._kaleoTaskAssignmentLocalService.deleteKaleoDefinitionVersionKaleoTaskAssignments(kaleoDefinitionVersionId);
        this._kaleoTaskFormLocalService.deleteKaleoDefinitionVersionKaleoTaskForms(kaleoDefinitionVersionId);
    }

    public KaleoTask getKaleoNodeKaleoTask(long kaleoNodeId) throws PortalException {
        return this.kaleoTaskPersistence.findByKaleoNodeId(kaleoNodeId);
    }
}

