/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class KaleoDefinitionModelListener
extends BaseModelListener<KaleoDefinition> {
    @Reference
    private MessageBus _messageBus;

    public void onAfterCreate(KaleoDefinition kaleoDefinition) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            Message message = new Message();
            message.put("command", (Object)"create");
            message.put("name", (Object)kaleoDefinition.getName());
            message.put("serviceContext", (Object)this.getServiceContext(kaleoDefinition));
            message.put("version", (Object)kaleoDefinition.getVersion());
            this._messageBus.sendMessage("liferay/kaleo_definition", message);
            return null;
        });
    }

    public void onAfterRemove(KaleoDefinition kaleoDefinition) throws ModelListenerException {
        if (kaleoDefinition == null) {
            return;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            try {
                Message message = new Message();
                message.put("command", (Object)"delete");
                message.put("name", (Object)kaleoDefinition.getName());
                message.put("serviceContext", (Object)this.getServiceContext(kaleoDefinition));
                message.put("version", (Object)kaleoDefinition.getVersion());
                this._messageBus.sendMessage("liferay/kaleo_definition", message);
            }
            catch (Exception exception) {
                throw new ModelListenerException((Throwable)exception);
            }
            return null;
        });
    }

    protected ServiceContext getServiceContext(KaleoDefinition kaleoDefinition) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setCompanyId(kaleoDefinition.getCompanyId());
        serviceContext.setScopeGroupId(kaleoDefinition.getGroupId());
        serviceContext.setUserId(kaleoDefinition.getUserId());
        return serviceContext;
    }
}

