/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.model.listener;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.workflow.kaleo.definition.ExecutionType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.action.KaleoActionExecutor;
import com.liferay.portal.workflow.kaleo.runtime.assignment.AggregateKaleoTaskAssignmentSelector;
import com.liferay.portal.workflow.kaleo.runtime.notification.NotificationHelper;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    @Reference
    private AggregateKaleoTaskAssignmentSelector _aggregateKaleoTaskAssignmentSelector;
    @Reference
    private KaleoActionExecutor _kaleoActionExecutor;
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoTaskAssignmentInstanceLocalService _kaleoTaskAssignmentInstanceLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference
    private NotificationHelper _notificationHelper;

    public void onAfterRemove(User user) throws ModelListenerException {
        try {
            this._reassignKaleoTaskInstance(user.getUserId());
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onAfterUpdate(User originalUser, User user) throws ModelListenerException {
        try {
            if (user.getStatus() == 5) {
                this._reassignKaleoTaskInstance(user.getUserId());
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _reassignKaleoTaskInstance(KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance) throws PortalException {
        final KaleoInstanceToken kaleoInstanceToken = this._kaleoInstanceTokenLocalService.getKaleoInstanceToken(kaleoTaskAssignmentInstance.getKaleoInstanceTokenId());
        KaleoTaskInstanceToken kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.getKaleoTaskInstanceToken(kaleoTaskAssignmentInstance.getKaleoTaskInstanceTokenId());
        final PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        ExecutionContext executionContext = new ExecutionContext(kaleoInstanceToken, kaleoTaskInstanceToken, WorkflowContextUtil.convert((String)kaleoTaskInstanceToken.getWorkflowContext()), new ServiceContext(){
            {
                this.setCompanyId(kaleoInstanceToken.getCompanyId());
                this.setScopeGroupId(kaleoInstanceToken.getGroupId());
                this.setUserId(permissionChecker.getUserId());
            }
        });
        KaleoTask kaleoTask = this._kaleoTaskLocalService.getKaleoTask(kaleoTaskAssignmentInstance.getKaleoTaskId());
        List previousTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
        kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.deleteKaleoTaskInstanceToken(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
        kaleoTaskInstanceToken = this._kaleoTaskInstanceTokenLocalService.addKaleoTaskInstanceToken(kaleoInstanceToken.getKaleoInstanceTokenId(), kaleoTask.getKaleoTaskId(), kaleoTask.getName(), this._aggregateKaleoTaskAssignmentSelector.getKaleoTaskAssignments(kaleoTask.getKaleoTaskAssignments(), executionContext), kaleoTaskInstanceToken.getDueDate(), executionContext.getWorkflowContext(), executionContext.getServiceContext());
        executionContext.setKaleoTaskInstanceToken(kaleoTaskInstanceToken);
        this._kaleoActionExecutor.executeKaleoActions(KaleoNode.class.getName(), kaleoTask.getKaleoNodeId(), ExecutionType.ON_ASSIGNMENT, executionContext);
        this._notificationHelper.sendKaleoNotifications(KaleoNode.class.getName(), kaleoTask.getKaleoNodeId(), ExecutionType.ON_ASSIGNMENT, executionContext);
        this._kaleoLogLocalService.addTaskAssignmentKaleoLogs(previousTaskAssignmentInstances, kaleoTaskInstanceToken, null, executionContext.getWorkflowContext(), executionContext.getServiceContext());
    }

    private void _reassignKaleoTaskInstance(long userId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._kaleoTaskAssignmentInstanceLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property assigneeClassNameProperty = PropertyFactoryUtil.forName((String)"assigneeClassName");
            dynamicQuery.add(assigneeClassNameProperty.like((Object)User.class.getName()));
            Property assigneeClassPKProperty = PropertyFactoryUtil.forName((String)"assigneeClassPK");
            dynamicQuery.add(assigneeClassPKProperty.eq((Object)userId));
            Property completedProperty = PropertyFactoryUtil.forName((String)"completed");
            dynamicQuery.add(completedProperty.eq((Object)false));
        });
        actionableDynamicQuery.setPerformActionMethod(kaleoTaskAssignmentInstance -> this._reassignKaleoTaskInstance((KaleoTaskAssignmentInstance)kaleoTaskAssignmentInstance));
        actionableDynamicQuery.performActions();
    }
}

