/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.model.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ServiceComponent;
import com.liferay.portal.kernel.upgrade.util.BaseUpgradeTableListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

public class BaseKaleoUpgradeTableListener
extends BaseUpgradeTableListener {
    private static final Log _log = LogFactoryUtil.getLog(BaseKaleoUpgradeTableListener.class);

    protected Map<Long, Long> getKeyValueMap(String tableName, String keyColumnName, String valueColumnName) {
        HashMap<Long, Long> keyValueMap = new HashMap<Long, Long>();
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ", keyColumnName, ", ", valueColumnName, " from ", tableName}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long key = resultSet.getLong(keyColumnName);
                long value = resultSet.getLong(valueColumnName);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"{", keyColumnName, "=", key, ", ", valueColumnName, "=", value, "}"}));
                }
                keyValueMap.put(key, value);
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        return keyValueMap;
    }

    protected boolean isFixAutoUpgrade(ServiceComponent previousServiceComponent) {
        return previousServiceComponent.getBuildNumber() < 4L;
    }

    protected void updateKeyValueMap(Map<Long, Long> keyValueMap, String kaleoClassName, String tableName, String keyColumnName) throws Exception {
        for (Map.Entry<Long, Long> entry : keyValueMap.entrySet()) {
            this.runSQL(StringBundler.concat((Object[])new Object[]{"update ", tableName, " set kaleoClassName = '", kaleoClassName, "', kaleoClassPK = ", entry.getValue(), " where ", keyColumnName, " = ", entry.getKey()}));
        }
    }
}

