/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKaleoModelDocumentContributor {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseKaleoModelDocumentContributor.class);

    protected void addAssetEntryAttributes(Consumer<AssetEntry> assetEntryConsumer, String className, long classPK, Document document, long groupId) {
        AssetEntry assetEntry = this._getAssetEntry(className, classPK);
        if (assetEntry != null) {
            document.addLocalizedText("assetDescription", LocalizationUtil.populateLocalizationMap((Map)assetEntry.getDescriptionMap(), (String)assetEntry.getDefaultLanguageId(), (long)assetEntry.getGroupId()));
            document.addLocalizedText("assetTitle", LocalizationUtil.populateLocalizationMap((Map)assetEntry.getTitleMap(), (String)assetEntry.getDefaultLanguageId(), (long)assetEntry.getGroupId()));
            assetEntryConsumer.accept(assetEntry);
        } else {
            WorkflowHandler workflowHandler = WorkflowHandlerRegistryUtil.getWorkflowHandler((String)className);
            if (workflowHandler == null) {
                return;
            }
            for (Locale availableLocale : LanguageUtil.getAvailableLocales((long)groupId)) {
                document.addText(LocalizationUtil.getLocalizedName((String)"assetTitle", (String)LocaleUtil.toLanguageId((Locale)availableLocale)), workflowHandler.getTitle(classPK, availableLocale));
            }
        }
    }

    protected void addAssetEntryAttributes(String className, long classPK, Document document, long groupId) {
        this.addAssetEntryAttributes(assetEntry -> {}, className, classPK, document, groupId);
    }

    private AssetEntry _getAssetEntry(String className, long classPK) {
        block3: {
            try {
                AssetRenderer<?> assetRenderer = this._getAssetRenderer(className, classPK);
                if (assetRenderer != null) {
                    return this.assetEntryLocalService.getEntry(assetRenderer.getClassName(), assetRenderer.getClassPK());
                }
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)portalException);
            }
        }
        return null;
    }

    private AssetRenderer<?> _getAssetRenderer(String className, long classPK) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory != null) {
            return assetRendererFactory.getAssetRenderer(classPK);
        }
        return null;
    }
}

