/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;

public class KaleoDefinitionModelIndexerWriterContributor
implements ModelIndexerWriterContributor<KaleoDefinition> {
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    private final KaleoDefinitionLocalService _kaleoDefinitionLocalService;

    public KaleoDefinitionModelIndexerWriterContributor(DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory, KaleoDefinitionLocalService kaleoDefinitionLocalService) {
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
        this._kaleoDefinitionLocalService = kaleoDefinitionLocalService;
    }

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setPerformActionMethod(kaleoDefinition -> batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)kaleoDefinition)}));
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._kaleoDefinitionLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(KaleoDefinition kaleoDefinition) {
        return kaleoDefinition.getCompanyId();
    }

    public void modelIndexed(KaleoDefinition kaleoDefinition) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KaleoDefinitionVersion.class);
        try {
            for (KaleoDefinitionVersion kaleoDefinitionVersion : kaleoDefinition.getKaleoDefinitionVersions()) {
                indexer.reindex((Object)kaleoDefinitionVersion);
            }
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }
}

