/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import org.osgi.service.component.annotations.Component;

@Component(property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion"}, service={ModelDocumentContributor.class})
public class KaleoDefinitionVersionModelDocumentContributor
implements ModelDocumentContributor<KaleoDefinitionVersion> {
    private static final Log _log = LogFactoryUtil.getLog(KaleoDefinitionVersionModelDocumentContributor.class);

    public void contribute(Document document, KaleoDefinitionVersion kaleoDefinitionVersion) {
        block2: {
            document.addKeyword("description", kaleoDefinitionVersion.getDescription());
            document.addKeyword("name", kaleoDefinitionVersion.getName());
            try {
                KaleoDefinition kaleoDefinition = kaleoDefinitionVersion.getKaleoDefinition();
                document.addNumber("active", kaleoDefinition.isActive() ? 1 : 0);
                document.addKeyword("scope", kaleoDefinition.getScope());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)portalException);
            }
        }
        document.addLocalizedText("title", kaleoDefinitionVersion.getTitleMap(), true);
        int[] versionParts = StringUtil.split((String)kaleoDefinitionVersion.getVersion(), (String)".", (int)0);
        document.addNumber("version", versionParts[0]);
    }
}

