/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor.BaseKaleoModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken"}, service={ModelDocumentContributor.class})
public class KaleoInstanceTokenModelDocumentContributor
extends BaseKaleoModelDocumentContributor
implements ModelDocumentContributor<KaleoInstanceToken> {
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected KaleoInstanceLocalService kaleoInstanceLocalService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(KaleoInstanceTokenModelDocumentContributor.class);
    @Reference
    private Localization _localization;

    public void contribute(Document document, KaleoInstanceToken kaleoInstanceToken) {
        block2: {
            document.addKeyword("className", kaleoInstanceToken.getClassName());
            document.addKeyword("classNameId", this.portal.getClassNameId(kaleoInstanceToken.getClassName()));
            document.addKeyword("classPK", kaleoInstanceToken.getClassPK());
            document.addKeywordSortable("completed", Boolean.valueOf(kaleoInstanceToken.isCompleted()));
            document.addDateSortable("completionDate", kaleoInstanceToken.getCompletionDate());
            document.addDateSortable("createDate", kaleoInstanceToken.getCreateDate());
            document.addKeywordSortable("currentKaleoNodeName", kaleoInstanceToken.getCurrentKaleoNodeName());
            document.addNumberSortable("kaleoInstanceId", Long.valueOf(kaleoInstanceToken.getKaleoInstanceId()));
            document.addKeyword("kaleoInstanceTokenId", kaleoInstanceToken.getKaleoInstanceTokenId());
            document.addDateSortable("modified", kaleoInstanceToken.getModifiedDate());
            document.addKeyword("parentKaleoInstanceTokenId", kaleoInstanceToken.getParentKaleoInstanceTokenId());
            try {
                KaleoInstance kaleoInstance = this.kaleoInstanceLocalService.getKaleoInstance(kaleoInstanceToken.getKaleoInstanceId());
                document.addKeyword("kaleoDefinitionName", kaleoInstance.getKaleoDefinitionName());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Throwable)portalException);
            }
        }
        this.addAssetEntryAttributes(kaleoInstanceToken.getClassName(), kaleoInstanceToken.getClassPK(), document, kaleoInstanceToken.getGroupId());
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = this._localization.getAvailableLanguageIds(content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

