/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;

public class KaleoInstanceTokenModelIndexerWriterContributor
implements ModelIndexerWriterContributor<KaleoInstanceToken> {
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    private final KaleoInstanceLocalService _kaleoInstanceLocalService;
    private final KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;

    public KaleoInstanceTokenModelIndexerWriterContributor(DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory, KaleoInstanceLocalService kaleoInstanceLocalService, KaleoInstanceTokenLocalService kaleoInstanceTokenLocalService) {
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
        this._kaleoInstanceLocalService = kaleoInstanceLocalService;
        this._kaleoInstanceTokenLocalService = kaleoInstanceTokenLocalService;
    }

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setPerformActionMethod(kaleoInstanceToken -> batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)kaleoInstanceToken)}));
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._kaleoInstanceTokenLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(KaleoInstanceToken kaleoInstanceToken) {
        return kaleoInstanceToken.getCompanyId();
    }

    public void modelIndexed(KaleoInstanceToken kaleoInstanceToken) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(KaleoInstance.class);
        try {
            indexer.reindex((Object)this._kaleoInstanceLocalService.getKaleoInstance(kaleoInstanceToken.getKaleoInstanceId()));
        }
        catch (SearchException searchException) {
            throw new SystemException((Throwable)searchException);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }
}

