/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.internal.search.spi.model.index.contributor.BaseKaleoModelDocumentContributor;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionVersionLocalService;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken"}, service={ModelDocumentContributor.class})
public class KaleoTaskInstanceTokenModelDocumentContributor
extends BaseKaleoModelDocumentContributor
implements ModelDocumentContributor<KaleoTaskInstanceToken> {
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected KaleoDefinitionVersionLocalService kaleoDefinitionVersionLocalService;
    @Reference
    protected Portal portal;
    private static final Log _log = LogFactoryUtil.getLog(KaleoTaskInstanceTokenModelDocumentContributor.class);
    @Reference
    private Localization _localization;

    public void contribute(Document document, KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        block3: {
            List kaleoTaskAssignmentInstances = kaleoTaskInstanceToken.getKaleoTaskAssignmentInstances();
            HashSet<Long> assigneeClassNameIds = new HashSet<Long>();
            HashSet<Long> assigneeClassPKs = new HashSet<Long>();
            HashSet<Long> assigneeGroupIds = new HashSet<Long>();
            for (KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance : kaleoTaskAssignmentInstances) {
                assigneeClassNameIds.add(this.portal.getClassNameId(kaleoTaskAssignmentInstance.getAssigneeClassName()));
                assigneeClassPKs.add(kaleoTaskAssignmentInstance.getAssigneeClassPK());
                assigneeGroupIds.add(kaleoTaskAssignmentInstance.getGroupId());
            }
            document.addKeyword("assigneeClassNameIds", assigneeClassNameIds.toArray(new Long[0]));
            document.addKeyword("assigneeClassPKs", assigneeClassPKs.toArray(new Long[0]));
            document.addKeyword("assigneeGroupIds", assigneeGroupIds.toArray(new Long[0]));
            document.addKeyword("className", kaleoTaskInstanceToken.getClassName());
            document.addKeyword("classNameId", this.portal.getClassNameId(kaleoTaskInstanceToken.getClassName()));
            document.addKeyword("classPK", kaleoTaskInstanceToken.getClassPK());
            document.addKeywordSortable("completed", Boolean.valueOf(kaleoTaskInstanceToken.isCompleted()));
            document.addDateSortable("completionDate", kaleoTaskInstanceToken.getCompletionDate());
            document.addDateSortable("createDate", kaleoTaskInstanceToken.getCreateDate());
            document.addDateSortable("dueDate", kaleoTaskInstanceToken.getDueDate());
            try {
                KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionLocalService.getKaleoDefinitionVersion(kaleoTaskInstanceToken.getKaleoDefinitionVersionId());
                KaleoDefinition kaleoDefinition = kaleoDefinitionVersion.getKaleoDefinition();
                document.addKeyword("kaleoDefinitionId", kaleoDefinition.getKaleoDefinitionId());
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)portalException);
            }
        }
        document.addNumberSortable("kaleoInstanceId", Long.valueOf(kaleoTaskInstanceToken.getKaleoInstanceId()));
        document.addNumberSortable("kaleoTaskId", Long.valueOf(kaleoTaskInstanceToken.getKaleoTaskId()));
        document.addNumberSortable("kaleoTaskInstanceTokenId", Long.valueOf(kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId()));
        document.addDateSortable("modified", kaleoTaskInstanceToken.getModifiedDate());
        document.addKeywordSortable("taskName", kaleoTaskInstanceToken.getKaleoTaskName());
        document.addNumberSortable("userId", Long.valueOf(kaleoTaskInstanceToken.getUserId()));
        this.addAssetEntryAttributes(assetEntry -> {
            document.addKeyword("assetClassNameId", assetEntry.getClassNameId());
            document.addKeyword("assetClassPK", assetEntry.getClassPK());
        }, kaleoTaskInstanceToken.getClassName(), kaleoTaskInstanceToken.getClassPK(), document, kaleoTaskInstanceToken.getGroupId());
    }

    protected String[] getLanguageIds(String defaultLanguageId, String content) {
        String[] languageIds = this._localization.getAvailableLanguageIds(content);
        if (languageIds.length == 0) {
            languageIds = new String[]{defaultLanguageId};
        }
        return languageIds;
    }
}

