/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoInstanceTokenQuery;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken"}, service={KeywordQueryContributor.class})
public class KaleoInstanceTokenKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected QueryHelper queryHelper;
    @Reference
    private Localization _localization;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        KaleoInstanceTokenQuery kaleoInstanceTokenQuery = this._getKaleoInstanceTokenQuery(keywordQueryContributorHelper);
        if (kaleoInstanceTokenQuery == null) {
            return;
        }
        this.appendAssetDescriptionTerm(booleanQuery, kaleoInstanceTokenQuery.getAssetDescription(), keywordQueryContributorHelper);
        this.appendAssetTitleTerm(booleanQuery, kaleoInstanceTokenQuery.getAssetTitle(), keywordQueryContributorHelper);
        this._appendClassNameTerm(booleanQuery, kaleoInstanceTokenQuery.getClassName(), keywordQueryContributorHelper);
        this.appendCurrentKaleoNodeNameTerm(booleanQuery, kaleoInstanceTokenQuery.getCurrentKaleoNodeName(), keywordQueryContributorHelper);
        this.appendKaleoDefinitionNameTerm(booleanQuery, kaleoInstanceTokenQuery.getKaleoDefinitionName(), keywordQueryContributorHelper);
    }

    protected void appendAssetDescriptionTerm(BooleanQuery booleanQuery, String assetDescription, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        if (Validator.isNull((String)assetDescription)) {
            return;
        }
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        String assetDescriptionLocalizedName = this._localization.getLocalizedName("assetDescription", searchContext.getLanguageId());
        searchContext.setAttribute(assetDescriptionLocalizedName, (Serializable)((Object)assetDescription));
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "assetDescription", true);
    }

    protected void appendAssetTitleTerm(BooleanQuery booleanQuery, String assetTitle, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        if (Validator.isNull((String)assetTitle)) {
            return;
        }
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        String assetTitleLocalizedName = this._localization.getLocalizedName("assetTitle", searchContext.getLanguageId());
        searchContext.setAttribute(assetTitleLocalizedName, (Serializable)((Object)assetTitle));
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "assetTitle", false);
    }

    protected void appendCurrentKaleoNodeNameTerm(BooleanQuery booleanQuery, String currentKaleoNodeName, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        if (Validator.isNull((String)currentKaleoNodeName)) {
            return;
        }
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        searchContext.setAttribute("currentKaleoNodeName", (Serializable)((Object)currentKaleoNodeName));
        this.queryHelper.addSearchTerm(booleanQuery, keywordQueryContributorHelper.getSearchContext(), "currentKaleoNodeName", false);
    }

    protected void appendKaleoDefinitionNameTerm(BooleanQuery booleanQuery, String kaleoDefinitionName, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        if (Validator.isNull((String)kaleoDefinitionName)) {
            return;
        }
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        searchContext.setAttribute("kaleoDefinitionName", (Serializable)((Object)kaleoDefinitionName));
        this.queryHelper.addSearchTerm(booleanQuery, keywordQueryContributorHelper.getSearchContext(), "kaleoDefinitionName", false);
    }

    private void _appendClassNameTerm(BooleanQuery booleanQuery, String className, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        if (Validator.isNull((String)className)) {
            return;
        }
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        searchContext.setAttribute("className", (Serializable)((Object)className));
        this.queryHelper.addSearchTerm(booleanQuery, keywordQueryContributorHelper.getSearchContext(), "className", false);
    }

    private KaleoInstanceTokenQuery _getKaleoInstanceTokenQuery(KeywordQueryContributorHelper keywordQueryContributorHelper) {
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        return (KaleoInstanceTokenQuery)searchContext.getAttribute("kaleoInstanceTokenQuery");
    }
}

