/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.helper.v1_3_0;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WorkflowContextUpgradeHelper {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowContextUpgradeHelper.class);
    private static final Map<String, String> _classNamesMap = HashMapBuilder.put((Object)"com.liferay.portal.model.Company", (Object)"com.liferay.portal.kernel.model.Company").put((Object)"com.liferay.portal.model.Group", (Object)"com.liferay.portal.kernel.model.Group").put((Object)"com.liferay.portal.model.LayoutRevision", (Object)"com.liferay.portal.kernel.model.LayoutRevision").put((Object)"com.liferay.portal.model.Role", (Object)"com.liferay.portal.kernel.model.Role").put((Object)"com.liferay.portal.model.User", (Object)"com.liferay.portal.kernel.model.User").put((Object)"com.liferay.portal.model.UserGroup", (Object)"com.liferay.portal.kernel.model.UserGroup").put((Object)"com.liferay.portlet.blogs.model.BlogsEntry", (Object)"com.liferay.blogs.kernel.model.BlogsEntry").put((Object)"com.liferay.portlet.documentlibrary.model.DLFileEntry", (Object)"com.liferay.document.library.kernel.model.DLFileEntry").put((Object)"com.liferay.portlet.dynamicdatalists.model.DDLRecord", (Object)"com.liferay.dynamic.data.lists.model.DDLRecord").put((Object)"com.liferay.portlet.journal.model.JournalArticle", (Object)"com.liferay.journal.model.JournalArticle").put((Object)"com.liferay.portlet.messageboards.model.MBDiscussion", (Object)"com.liferay.message.boards.kernel.model.MBDiscussion").put((Object)"com.liferay.portlet.messageboards.model.MBMessage", (Object)"com.liferay.message.boards.kernel.model.MBMessage").put((Object)"com.liferay.portlet.wiki.model.WikiPage", (Object)"com.liferay.wiki.model.WikiPage").build();
    private static final Pattern _javaClassPattern = Pattern.compile("\"javaClass\":\"(com.liferay.portal.[^\"]+)\"");

    public Set<Map.Entry<String, String>> getRenamedClassNamesEntrySet() {
        return _classNamesMap.entrySet();
    }

    public boolean isEntryClassNameRenamed(Map<String, Serializable> workflowContext) {
        String oldEntryClassName = (String)((Object)workflowContext.get("entryClassName"));
        return _classNamesMap.get(oldEntryClassName) != null;
    }

    public Map<String, Serializable> renameEntryClassName(Map<String, Serializable> workflowContext) {
        HashMap<String, Serializable> newWorkflowContext = new HashMap<String, Serializable>(workflowContext);
        String oldEntryClassName = (String)((Object)workflowContext.get("entryClassName"));
        String newEntryClassName = _classNamesMap.get(oldEntryClassName);
        if (newEntryClassName != null) {
            newWorkflowContext.put("entryClassName", (Serializable)((Object)newEntryClassName));
        }
        return newWorkflowContext;
    }

    public String renamePortalClassNames(String workflowContextJSON) {
        Matcher matcher = _javaClassPattern.matcher(workflowContextJSON);
        TreeSet<CallSite> oldSubs = new TreeSet<CallSite>();
        TreeSet<CallSite> newSubs = new TreeSet<CallSite>();
        while (matcher.find()) {
            String oldPortalJavaClassName = matcher.group(1);
            if (oldPortalJavaClassName.contains(".impl") || oldPortalJavaClassName.contains(".kernel") || oldSubs.contains(oldPortalJavaClassName)) continue;
            oldSubs.add((CallSite)((Object)("\"javaClass\":\"" + oldPortalJavaClassName + "\"")));
            String newPortalJavaClassName = StringUtil.replace((String)oldPortalJavaClassName, (String)"com.liferay.portal", (String)"com.liferay.portal.kernel");
            newSubs.add((CallSite)((Object)("\"javaClass\":\"" + newPortalJavaClassName + "\"")));
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)String.format("Workflow context Java class name renamed from \"%s\" to \"%s\"", oldPortalJavaClassName, newPortalJavaClassName));
        }
        if (oldSubs.isEmpty()) {
            return workflowContextJSON;
        }
        return StringUtil.replace((String)workflowContextJSON, (String[])ArrayUtil.toStringArray(oldSubs), (String[])ArrayUtil.toStringArray(newSubs));
    }
}

