/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v1_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;

public class KaleoTaskInstanceTokenUpgradeProcess
extends UpgradeProcess {
    private final Set<Long> _kaleoInstanceTokenIds = new HashSet<Long>();

    protected void doUpgrade() throws Exception {
        this._updateKaleoTaskInstanceTokens();
        this._deleteKaleoInstanceTokens();
    }

    private void _deleteKaleoInstanceTokens() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (this._kaleoInstanceTokenIds.isEmpty()) {
                return;
            }
            StringBundler sb = new StringBundler(this._kaleoInstanceTokenIds.size() * 4 + 1);
            sb.append("delete from KaleoInstanceToken where ");
            for (long kaleoInstanceTokenId : this._kaleoInstanceTokenIds) {
                sb.append("(kaleoInstanceTokenId = ");
                sb.append(kaleoInstanceTokenId);
                sb.append(")");
                sb.append(" OR ");
            }
            sb.setIndex(sb.index() - 1);
            String sql = sb.toString();
            this.runSQL(sql);
        }
    }

    private long _getKaleoInstanceTokenId(long kaleoInstanceTokenId) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select KaleoNode.type_, ", "KaleoInstanceToken.kaleoInstanceTokenId from KaleoNode ", "inner join KaleoInstanceToken on (KaleoNode.kaleoNodeId ", "= KaleoInstanceToken.currentKaleoNodeId) where ", "KaleoInstanceToken.kaleoInstanceTokenId = (select ", "parentKaleoInstanceTokenId from KaleoInstanceToken where ", "kaleoInstanceTokenId = ?)"}));){
            long l;
            block20: {
                ResultSet resultSet;
                block16: {
                    long l2;
                    block19: {
                        block17: {
                            long l3;
                            block18: {
                                preparedStatement.setLong(1, kaleoInstanceTokenId);
                                resultSet = preparedStatement.executeQuery();
                                try {
                                    if (!resultSet.next()) break block16;
                                    String type = resultSet.getString("type_");
                                    if (type.equals(NodeType.TASK.toString())) break block17;
                                    l3 = kaleoInstanceTokenId;
                                    if (resultSet == null) break block18;
                                }
                                catch (Throwable throwable) {
                                    if (resultSet != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                resultSet.close();
                            }
                            return l3;
                        }
                        long parentKaleoInstanceTokenId = resultSet.getLong("kaleoInstanceTokenId");
                        this._kaleoInstanceTokenIds.add(kaleoInstanceTokenId);
                        l2 = this._getKaleoInstanceTokenId(parentKaleoInstanceTokenId);
                        if (resultSet == null) break block19;
                        resultSet.close();
                    }
                    return l2;
                }
                l = kaleoInstanceTokenId;
                if (resultSet == null) break block20;
                resultSet.close();
            }
            return l;
        }
    }

    private void _updateKaleoTaskInstanceTokens() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement("select kaleoTaskInstanceTokenId, kaleoInstanceTokenId from KaleoTaskInstanceToken");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long newKaleoInstanceTokenId;
                long oldKaleoInstanceTokenId = resultSet.getLong("kaleoInstanceTokenId");
                if (oldKaleoInstanceTokenId == (newKaleoInstanceTokenId = this._getKaleoInstanceTokenId(oldKaleoInstanceTokenId))) continue;
                StringBundler sb = new StringBundler(5);
                sb.append("update KaleoTaskInstanceToken set ");
                sb.append("kaleoInstanceTokenId = ");
                sb.append(newKaleoInstanceTokenId);
                sb.append(" where kaleoTaskInstanceTokenId = ");
                long kaleoTaskInstanceTokenId = resultSet.getLong("kaleoTaskInstanceTokenId");
                sb.append(kaleoTaskInstanceTokenId);
                String sql = sb.toString();
                this.runSQL(sql);
            }
        }
    }
}

