/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v1_1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.internal.upgrade.helper.v1_3_0.WorkflowContextUpgradeHelper;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.Serializer;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONObject;

public class WorkflowContextUpgradeProcess
extends UpgradeProcess {
    private JSONSerializer _jsonSerializer;
    private final WorkflowContextUpgradeHelper _workflowContextUpgradeHelper = new WorkflowContextUpgradeHelper();

    protected void doUpgrade() throws Exception {
        this._updateTable("KaleoInstance", "kaleoInstanceId");
        this._updateTable("KaleoLog", "kaleoLogId");
        this._updateTable("KaleoTaskInstanceToken", "kaleoTaskInstanceTokenId");
    }

    private JSONSerializer _getJSONSerializer() throws Exception {
        if (this._jsonSerializer == null) {
            this._jsonSerializer = new JSONSerializer();
            this._jsonSerializer.registerDefaultSerializers();
            this._jsonSerializer.registerSerializer((Serializer)new PortletPreferencesIdsSerializer());
        }
        return this._jsonSerializer;
    }

    private void _updateTable(String tableName, String fieldName) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);
             PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ", fieldName, ", workflowContext from ", tableName, " where workflowContext is not null and workflowContext ", "not like '%serializable%'"}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            JSONSerializer jsonSerializer = this._getJSONSerializer();
            while (resultSet.next()) {
                String workflowContextJSON = resultSet.getString("workflowContext");
                if (Validator.isNull((String)workflowContextJSON)) continue;
                long fieldValue = resultSet.getLong(fieldName);
                workflowContextJSON = this._workflowContextUpgradeHelper.renamePortalClassNames(workflowContextJSON);
                Map<String, Serializable> workflowContext = (Map<String, Serializable>)jsonSerializer.fromJSON(workflowContextJSON);
                workflowContext = this._workflowContextUpgradeHelper.renameEntryClassName(workflowContext);
                this._updateWorkflowContext(tableName, fieldName, fieldValue, WorkflowContextUtil.convert(workflowContext));
            }
        }
    }

    private void _updateWorkflowContext(String tableName, String primaryKeyName, long primaryKeyValue, String workflowContext) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update ", tableName, " set workflowContext = ? where ", primaryKeyName, " = ?"}));){
            preparedStatement.setString(1, workflowContext);
            preparedStatement.setLong(2, primaryKeyValue);
            preparedStatement.executeUpdate();
        }
    }

    private static class PortletPreferencesIdsSerializer
    extends AbstractSerializer {
        private static final Class<?>[] _JSON_CLASSES = new Class[]{JSONObject.class};
        private static final Class<?>[] _SERIALIZABLE_CLASSES = new Class[]{PortletPreferencesIds.class};

        private PortletPreferencesIdsSerializer() {
        }

        public Class<?>[] getJSONClasses() {
            return _JSON_CLASSES;
        }

        public Class<?>[] getSerializableClasses() {
            return _SERIALIZABLE_CLASSES;
        }

        public Object marshall(SerializerState serializerState, Object parentObject, Object object) throws MarshallException {
            throw new UnsupportedOperationException("The marshall operation is unsupported");
        }

        public ObjectMatch tryUnmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
            JSONObject portletPreferencesIdsJSONObject = (JSONObject)object;
            ObjectMatch objectMatch = ObjectMatch.ROUGHLY_SIMILAR;
            if (portletPreferencesIdsJSONObject.has("companyId") && portletPreferencesIdsJSONObject.has("ownerId") && portletPreferencesIdsJSONObject.has("ownerType") && portletPreferencesIdsJSONObject.has("plid") && portletPreferencesIdsJSONObject.has("portletId")) {
                objectMatch = ObjectMatch.OKAY;
            }
            serializerState.setSerialized(object, (Object)objectMatch);
            return objectMatch;
        }

        public Object unmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
            JSONObject portletPreferencesIdsJSONObject = (JSONObject)object;
            long companyId = 0L;
            try {
                companyId = portletPreferencesIdsJSONObject.getLong("companyId");
            }
            catch (Exception exception) {
                throw new UnmarshallException("companyId is undefined", (Throwable)exception);
            }
            long ownerId = 0L;
            try {
                ownerId = portletPreferencesIdsJSONObject.getLong("ownerId");
            }
            catch (Exception exception) {
                throw new UnmarshallException("ownerId is undefined", (Throwable)exception);
            }
            int ownerType = 0;
            try {
                ownerType = portletPreferencesIdsJSONObject.getInt("ownerType");
            }
            catch (Exception exception) {
                throw new UnmarshallException("ownerType is undefined", (Throwable)exception);
            }
            long plid = 0L;
            try {
                plid = portletPreferencesIdsJSONObject.getLong("plid");
            }
            catch (Exception exception) {
                throw new UnmarshallException("plid is undefined", (Throwable)exception);
            }
            String portletId = null;
            try {
                portletId = portletPreferencesIdsJSONObject.getString("portletId");
            }
            catch (Exception exception) {
                throw new UnmarshallException("portletId is undefined", (Throwable)exception);
            }
            PortletPreferencesIds portletPreferencesIds = new PortletPreferencesIds(companyId, ownerId, ownerType, plid, portletId);
            serializerState.setSerialized(object, (Object)portletPreferencesIds);
            return portletPreferencesIds;
        }
    }
}

