/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v1_3_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;

public abstract class BaseUpgradeClassNames
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateClassName("KaleoInstance", "className");
        this.updateClassName("KaleoInstanceToken", "className");
        this.updateClassName("KaleoLog", "currentAssigneeClassName");
        this.updateClassName("KaleoLog", "previousAssigneeClassName");
        this.updateClassName("KaleoNotificationRecipient", "recipientClassName");
        this.updateClassName("KaleoTaskAssignment", "assigneeClassName");
        this.updateClassName("KaleoTaskAssignmentInstance", "assigneeClassName");
        this.updateClassName("KaleoTaskInstanceToken", "className");
        this._updateWorkflowContextEntryClassName("KaleoInstance", "kaleoInstanceId");
        this._updateWorkflowContextEntryClassName("KaleoLog", "kaleoLogId");
        this._updateWorkflowContextEntryClassName("KaleoTaskInstanceToken", "kaleoTaskInstanceTokenId");
        this._updateWorkflowContextEntryClassName("KaleoTimerInstanceToken", "kaleoTimerInstanceTokenId");
    }

    protected abstract String getWhereClause();

    protected abstract void updateClassName(String var1, String var2);

    protected abstract Map<String, Serializable> updateWorkflowContext(String var1);

    protected void updateWorkflowContext(String tableName, String primaryKeyName, long primaryKeyValue, String workflowContext) throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"update ", tableName, " set workflowContext = ? where ", primaryKeyName, " = ?"}));){
            preparedStatement.setString(1, workflowContext);
            preparedStatement.setLong(2, primaryKeyValue);
            preparedStatement.executeUpdate();
        }
    }

    private void _updateWorkflowContextEntryClassName(String tableName, String primaryKeyName) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);
             PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select ", primaryKeyName, ", workflowContext from ", tableName, this.getWhereClause()}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                Map<String, Serializable> workflowContext;
                String workflowContextJSON = resultSet.getString("workflowContext");
                if (Validator.isNull((String)workflowContextJSON) || (workflowContext = this.updateWorkflowContext(workflowContextJSON)) == null) continue;
                long primaryKeyValue = resultSet.getLong(primaryKeyName);
                this.updateWorkflowContext(tableName, primaryKeyName, primaryKeyValue, WorkflowContextUtil.convert(workflowContext));
            }
        }
    }
}

