/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v1_3_0;

import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.upgrade.util.Table;
import com.liferay.portal.workflow.kaleo.internal.upgrade.helper.v1_3_0.WorkflowContextUpgradeHelper;
import com.liferay.portal.workflow.kaleo.internal.upgrade.v1_3_0.BaseUpgradeClassNames;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import java.io.Serializable;
import java.util.Map;

public class UpgradeClassNames
extends BaseUpgradeClassNames {
    private final WorkflowContextUpgradeHelper _workflowContextUpgradeHelper = new WorkflowContextUpgradeHelper();

    @Override
    protected String getWhereClause() {
        return " where workflowContext is not null";
    }

    @Override
    protected void updateClassName(String tableName, String columnName) {
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);){
            Table table = new Table(tableName);
            for (Map.Entry<String, String> entry : this._workflowContextUpgradeHelper.getRenamedClassNamesEntrySet()) {
                table.updateColumnValue(columnName, entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected Map<String, Serializable> updateWorkflowContext(String workflowContextJSON) {
        String updatedWorkflowContextJSON = this._workflowContextUpgradeHelper.renamePortalClassNames(workflowContextJSON);
        Map workflowContext = WorkflowContextUtil.convert((String)updatedWorkflowContextJSON);
        if (workflowContextJSON.equals(updatedWorkflowContextJSON) && !this._workflowContextUpgradeHelper.isEntryClassNameRenamed(workflowContext)) {
            return null;
        }
        return this._workflowContextUpgradeHelper.renameEntryClassName(workflowContext);
    }
}

