/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.upgrade.v3_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class SchemaUpgradeProcess
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"KaleoAction", "KaleoCondition", "KaleoDefinitionVersion", "KaleoInstance", "KaleoInstanceToken", "KaleoLog", "KaleoNode", "KaleoNotification", "KaleoNotificationRecipient", "KaleoTask", "KaleoTaskAssignment", "KaleoTaskAssignmentInstance", "KaleoTaskForm", "KaleoTaskFormInstance", "KaleoTaskInstanceToken", "KaleoTimer", "KaleoTimerInstanceToken", "KaleoTransition"};

    protected void doUpgrade() throws Exception {
        this._addKaleoDefinitionId();
        this._upgradeKaleoDefinitionId();
    }

    private void _addBatch(PreparedStatement preparedStatement, long kaleoDefinitionId, long kaleoDefinitionVersionId) throws SQLException {
        preparedStatement.setLong(1, kaleoDefinitionId);
        preparedStatement.setLong(2, kaleoDefinitionVersionId);
        preparedStatement.addBatch();
    }

    private void _addKaleoDefinitionId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.alterTableAddColumn("KaleoAction", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoCondition", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoDefinitionVersion", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoInstance", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoInstanceToken", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoLog", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoNode", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoNotification", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoNotificationRecipient", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTask", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTaskAssignment", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTaskAssignmentInstance", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTaskForm", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTaskFormInstance", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTaskInstanceToken", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTimer", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTimerInstanceToken", "kaleoDefinitionId", "LONG");
            this.alterTableAddColumn("KaleoTransition", "kaleoDefinitionId", "LONG");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _upgradeKaleoDefinitionId() throws Exception {
        ArrayList<PreparedStatement> preparedStatements = new ArrayList<PreparedStatement>(18);
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select KaleoDefinition.kaleoDefinitionId, ", "KaleoDefinitionVersion.kaleoDefinitionVersionId from ", "KaleoDefinitionVersion inner join KaleoDefinition on ", "KaleoDefinition.companyId = ", "KaleoDefinitionVersion.companyId and ", "KaleoDefinition.name = KaleoDefinitionVersion.name"}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            for (String tableName : _TABLE_NAMES) {
                preparedStatements.add(AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"update ", tableName, " set kaleoDefinitionId = ? where ", "kaleoDefinitionVersionId = ? "})));
            }
            while (resultSet.next()) {
                long kaleoDefinitionId = resultSet.getLong("kaleoDefinitionId");
                long kaleoDefinitionVersionId = resultSet.getLong("kaleoDefinitionVersionId");
                for (PreparedStatement curPreparedStatement : preparedStatements) {
                    this._addBatch(curPreparedStatement, kaleoDefinitionId, kaleoDefinitionVersionId);
                }
            }
            for (PreparedStatement curPreparedStatement : preparedStatements) {
                curPreparedStatement.executeBatch();
            }
        }
        finally {
            for (PreparedStatement curPreparedStatement : preparedStatements) {
                DataAccess.cleanUp((Statement)curPreparedStatement);
            }
        }
    }
}

