/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.internal.util;

import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.DuplicateRoleException;
import com.liferay.portal.kernel.exception.NoSuchRoleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.role.RoleConstants;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.roles.admin.role.type.contributor.RoleTypeContributor;
import com.liferay.roles.admin.role.type.contributor.provider.RoleTypeContributorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class RoleUtil {
    private static final String _LEGACY_TYPE_COMMUNITY_LABEL = "community";
    private static final ServiceTracker<RoleTypeContributorProvider, RoleTypeContributorProvider> _serviceTracker;

    public static Role getRole(String name, int roleType, boolean autoCreate, ServiceContext serviceContext) throws PortalException {
        Role role = RoleLocalServiceUtil.fetchRole((long)serviceContext.getCompanyId(), (String)name);
        if (role == null) {
            if (!autoCreate) {
                throw new NoSuchRoleException(StringBundler.concat((Object[])new Object[]{"No Role exists with the key {companyId=", serviceContext.getCompanyId(), ", name=", name, "}"}));
            }
            HashMap descriptionMap = HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)"This is an autogenerated role from the workflow definition.").build();
            if (roleType == 6) {
                AccountRole accountRole = AccountRoleLocalServiceUtil.addAccountRole(null, (long)serviceContext.getUserId(), (long)0L, (String)name, null, (Map)descriptionMap);
                role = accountRole.getRole();
            } else {
                role = RoleLocalServiceUtil.addRole(null, (long)serviceContext.getUserId(), null, (long)0L, (String)name, null, (Map)descriptionMap, (int)roleType, null, null);
            }
        } else if (role.getType() != roleType) {
            throw new DuplicateRoleException("Role already exists with name " + name);
        }
        return role;
    }

    public static List<Long> getRoleIds(ServiceContext serviceContext) {
        List roles = RoleLocalServiceUtil.getUserRoles((long)serviceContext.getUserId());
        ArrayList<Long> roleIds = new ArrayList<Long>(roles.size());
        for (Role role : roles) {
            roleIds.add(role.getRoleId());
        }
        return roleIds;
    }

    public static int getRoleType(String roleType) {
        RoleTypeContributorProvider roleTypeContributorProvider = (RoleTypeContributorProvider)_serviceTracker.getService();
        for (RoleTypeContributor roleTypeContributor : roleTypeContributorProvider.getRoleTypeContributors()) {
            if (!roleType.equals(roleTypeContributor.getTypeLabel())) continue;
            return roleTypeContributor.getType();
        }
        if (roleType.equals(_LEGACY_TYPE_COMMUNITY_LABEL)) {
            return 2;
        }
        return RoleConstants.getLabelType((String)roleType);
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(RoleTypeContributorProvider.class);
        ServiceTracker serviceTracker = new ServiceTracker(bundle.getBundleContext(), RoleTypeContributorProvider.class, null);
        serviceTracker.open();
        _serviceTracker = serviceTracker;
    }
}

