/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.service.KaleoDefinitionLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoDefinitionServiceBaseImpl;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=kaleo", "json.web.service.context.path=KaleoDefinition"}, service={AopService.class})
public class KaleoDefinitionServiceImpl
extends KaleoDefinitionServiceBaseImpl {
    @Reference
    private KaleoDefinitionLocalService _kaleoDefinitionLocalService;
    @Reference(target="(model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoDefinition)")
    private ModelResourcePermission<KaleoDefinition> _kaleoDefinitionModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.portal.workflow)")
    private PortletResourcePermission _portletResourcePermission;

    public KaleoDefinition addKaleoDefinition(String externalReferenceCode, String name, String title, String description, String content, String scope, int version, ServiceContext serviceContext) throws PortalException {
        this._checkPermissions(serviceContext);
        return this._kaleoDefinitionLocalService.addKaleoDefinition(externalReferenceCode, name, title, description, content, scope, version, serviceContext);
    }

    public KaleoDefinition getKaleoDefinition(long kaleoDefinitionId) throws PortalException {
        this._kaleoDefinitionModelResourcePermission.check(this.getPermissionChecker(), null, "VIEW");
        return this._kaleoDefinitionLocalService.getKaleoDefinition(kaleoDefinitionId);
    }

    public KaleoDefinition getKaleoDefinition(String externalReferenceCode, long companyId) throws PortalException {
        this._kaleoDefinitionModelResourcePermission.check(this.getPermissionChecker(), null, "VIEW");
        return this._kaleoDefinitionLocalService.getKaleoDefinitionByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public KaleoDefinition getKaleoDefinition(String name, ServiceContext serviceContext) throws PortalException {
        this._kaleoDefinitionModelResourcePermission.check(this.getPermissionChecker(), null, "VIEW");
        return this._kaleoDefinitionLocalService.getKaleoDefinition(name, serviceContext);
    }

    public List<KaleoDefinition> getScopeKaleoDefinitions(String scope, boolean active, int start, int end, OrderByComparator<KaleoDefinition> orderByComparator, ServiceContext serviceContext) throws PortalException {
        this._kaleoDefinitionModelResourcePermission.check(this.getPermissionChecker(), null, "VIEW");
        return this._kaleoDefinitionLocalService.getScopeKaleoDefinitions(scope, active, start, end, orderByComparator, serviceContext);
    }

    public List<KaleoDefinition> getScopeKaleoDefinitions(String scope, int start, int end, OrderByComparator<KaleoDefinition> orderByComparator, ServiceContext serviceContext) throws PortalException {
        this._kaleoDefinitionModelResourcePermission.check(this.getPermissionChecker(), null, "VIEW");
        return this._kaleoDefinitionLocalService.getScopeKaleoDefinitions(scope, start, end, orderByComparator, serviceContext);
    }

    public KaleoDefinition updateKaleoDefinition(String externalReferenceCode, long kaleoDefinitionId, String title, String description, String content, ServiceContext serviceContext) throws PortalException {
        this._checkPermissions(serviceContext);
        return this._kaleoDefinitionLocalService.updatedKaleoDefinition(externalReferenceCode, kaleoDefinitionId, title, description, content, serviceContext);
    }

    private void _checkPermissions(ServiceContext serviceContext) throws PrincipalException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !GetterUtil.getBoolean((Object)serviceContext.getAttribute("checkPermission"), (boolean)true)) {
            return;
        }
        this._portletResourcePermission.check(permissionChecker, serviceContext.getScopeGroupId(), "ADD_DEFINITION");
    }
}

