/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.TermsAggregation;
import com.liferay.portal.search.aggregation.bucket.TermsAggregationResult;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregation;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregationResult;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.search.SearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.query.StringQuery;
import com.liferay.portal.search.query.TermsQuery;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.workflow.exception.IncompleteWorkflowInstancesException;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinition;
import com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion;
import com.liferay.portal.workflow.kaleo.service.KaleoConditionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTransitionLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoDefinitionVersionLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.util.comparator.KaleoDefinitionVersionIdComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoDefinitionVersion"}, service={AopService.class})
public class KaleoDefinitionVersionLocalServiceImpl
extends KaleoDefinitionVersionLocalServiceBaseImpl {
    @Reference
    private Aggregations _aggregations;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private KaleoConditionLocalService _kaleoConditionLocalService;
    @Reference
    private KaleoInstanceLocalService _kaleoInstanceLocalService;
    @Reference
    private KaleoNodeLocalService _kaleoNodeLocalService;
    @Reference
    private KaleoTaskLocalService _kaleoTaskLocalService;
    @Reference
    private KaleoTransitionLocalService _kaleoTransitionLocalService;
    @Reference
    private Queries _queries;
    @Reference
    private QueryHelper _queryHelper;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;
    @Reference
    private SearchRequestExecutor _searchRequestExecutor;
    @Reference
    private Sorts _sorts;
    @Reference
    private Staging _staging;
    @Reference
    private UserLocalService _userLocalService;

    public KaleoDefinitionVersion addKaleoDefinitionVersion(long kaleoDefinitionId, String name, String title, String description, String content, String version, ServiceContext serviceContext) throws PortalException {
        Date createDate = serviceContext.getCreateDate(new Date());
        Date modifiedDate = serviceContext.getModifiedDate(new Date());
        User user = this._userLocalService.getUser(serviceContext.getGuestOrUserId());
        long kaleoDefinitionVersionId = this.counterLocalService.increment();
        KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionPersistence.create(kaleoDefinitionVersionId);
        kaleoDefinitionVersion.setGroupId(this._staging.getLiveGroupId(serviceContext.getScopeGroupId()));
        kaleoDefinitionVersion.setCompanyId(user.getCompanyId());
        kaleoDefinitionVersion.setUserId(user.getUserId());
        kaleoDefinitionVersion.setUserName(user.getFullName());
        kaleoDefinitionVersion.setCreateDate(createDate);
        kaleoDefinitionVersion.setModifiedDate(modifiedDate);
        kaleoDefinitionVersion.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoDefinitionVersion.setName(name);
        kaleoDefinitionVersion.setTitle(title);
        kaleoDefinitionVersion.setDescription(description);
        kaleoDefinitionVersion.setContent(content);
        kaleoDefinitionVersion.setVersion(version);
        kaleoDefinitionVersion.setStatus(GetterUtil.getInteger((Object)serviceContext.getAttribute("status"), (int)0));
        kaleoDefinitionVersion.setStatusByUserId(user.getUserId());
        kaleoDefinitionVersion.setStatusByUserName(user.getFullName());
        kaleoDefinitionVersion.setStatusDate(modifiedDate);
        kaleoDefinitionVersion = (KaleoDefinitionVersion)this.kaleoDefinitionVersionPersistence.update((BaseModel)kaleoDefinitionVersion);
        this._resourceLocalService.addModelResources((AuditedModel)kaleoDefinitionVersion, serviceContext);
        return kaleoDefinitionVersion;
    }

    @Override
    @SystemEvent(type=1)
    public KaleoDefinitionVersion deleteKaleoDefinitionVersion(KaleoDefinitionVersion kaleoDefinitionVersion) throws PortalException {
        int kaleoInstancesCount = this._kaleoInstanceLocalService.getKaleoInstancesCount(kaleoDefinitionVersion.getKaleoDefinitionVersionId(), false);
        if (kaleoInstancesCount > 0) {
            throw new IncompleteWorkflowInstancesException(kaleoInstancesCount);
        }
        this.kaleoDefinitionVersionPersistence.remove((BaseModel)kaleoDefinitionVersion);
        this._resourceLocalService.deleteResource((AuditedModel)kaleoDefinitionVersion, 4);
        this._kaleoConditionLocalService.deleteKaleoDefinitionVersionKaleoCondition(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        this._kaleoInstanceLocalService.deleteKaleoDefinitionVersionKaleoInstances(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        this._kaleoNodeLocalService.deleteKaleoDefinitionVersionKaleoNodes(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        this._kaleoTaskLocalService.deleteKaleoDefinitionVersionKaleoTasks(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        this._kaleoTransitionLocalService.deleteKaleoDefinitionVersionKaleoTransitions(kaleoDefinitionVersion.getKaleoDefinitionVersionId());
        return kaleoDefinitionVersion;
    }

    public void deleteKaleoDefinitionVersion(long companyId, String name, String version) throws PortalException {
        this.kaleoDefinitionVersionLocalService.deleteKaleoDefinitionVersion(this.getKaleoDefinitionVersion(companyId, name, version));
    }

    public void deleteKaleoDefinitionVersions(KaleoDefinition kaleoDefinition) throws PortalException {
        int kaleoInstancesCount = this._kaleoInstanceLocalService.getKaleoDefinitionKaleoInstancesCount(kaleoDefinition.getKaleoDefinitionId(), false);
        if (kaleoInstancesCount > 0) {
            throw new IncompleteWorkflowInstancesException(kaleoInstancesCount);
        }
        for (KaleoDefinitionVersion kaleoDefinitionVersion : kaleoDefinition.getKaleoDefinitionVersions()) {
            this.kaleoDefinitionVersionLocalService.deleteKaleoDefinitionVersion(kaleoDefinitionVersion);
        }
    }

    public void deleteKaleoDefinitionVersions(List<KaleoDefinitionVersion> kaleoDefinitionVersions) throws PortalException {
        for (KaleoDefinitionVersion kaleoDefinitionVersion : kaleoDefinitionVersions) {
            this.kaleoDefinitionVersionLocalService.deleteKaleoDefinitionVersion(kaleoDefinitionVersion);
        }
    }

    public void deleteKaleoDefinitionVersions(long companyId, String name) throws PortalException {
        this.kaleoDefinitionVersionLocalService.deleteKaleoDefinitionVersions(this.getKaleoDefinitionVersions(companyId, name));
    }

    public KaleoDefinitionVersion fetchKaleoDefinitionVersion(long companyId, String name, String version) {
        return this.kaleoDefinitionVersionPersistence.fetchByC_N_V(companyId, name, version);
    }

    public KaleoDefinitionVersion fetchLatestKaleoDefinitionVersion(long companyId, String name) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.fetchByC_N_First(companyId, name, (OrderByComparator)KaleoDefinitionVersionIdComparator.getInstance((boolean)false));
    }

    public KaleoDefinitionVersion fetchLatestKaleoDefinitionVersion(long companyId, String name, OrderByComparator<KaleoDefinitionVersion> orderByComparator) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.fetchByC_N_Last(companyId, name, orderByComparator);
    }

    public KaleoDefinitionVersion getFirstKaleoDefinitionVersion(long companyId, String name) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.findByC_N_First(companyId, name, (OrderByComparator)KaleoDefinitionVersionIdComparator.getInstance((boolean)true));
    }

    public KaleoDefinitionVersion getKaleoDefinitionVersion(long companyId, String name, String version) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.findByC_N_V(companyId, name, version);
    }

    public List<KaleoDefinitionVersion> getKaleoDefinitionVersions(long companyId, int start, int end, OrderByComparator<KaleoDefinitionVersion> orderByComparator) {
        return this.kaleoDefinitionVersionPersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<KaleoDefinitionVersion> getKaleoDefinitionVersions(long companyId, String name) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.findByC_N(companyId, name);
    }

    public List<KaleoDefinitionVersion> getKaleoDefinitionVersions(long companyId, String name, int start, int end, OrderByComparator<KaleoDefinitionVersion> orderByComparator) {
        return this.kaleoDefinitionVersionPersistence.findByC_N(companyId, name, start, end, orderByComparator);
    }

    public int getKaleoDefinitionVersionsCount(long companyId) {
        return this.kaleoDefinitionVersionPersistence.countByCompanyId(companyId);
    }

    public int getKaleoDefinitionVersionsCount(long companyId, String name) {
        return this.kaleoDefinitionVersionPersistence.countByC_N(companyId, name);
    }

    public KaleoDefinitionVersion[] getKaleoDefinitionVersionsPrevAndNext(long companyId, String name, String version) throws PortalException {
        KaleoDefinitionVersion kaleoDefinitionVersion = this.kaleoDefinitionVersionPersistence.findByC_N_V(companyId, name, version);
        return this.kaleoDefinitionVersionPersistence.findByC_N_PrevAndNext(kaleoDefinitionVersion.getKaleoDefinitionVersionId(), companyId, name, (OrderByComparator)KaleoDefinitionVersionIdComparator.getInstance((boolean)true));
    }

    public KaleoDefinitionVersion getLatestKaleoDefinitionVersion(long companyId, String name) throws PortalException {
        return this.kaleoDefinitionVersionPersistence.findByC_N_First(companyId, name, (OrderByComparator)KaleoDefinitionVersionIdComparator.getInstance((boolean)false));
    }

    public List<KaleoDefinitionVersion> getLatestKaleoDefinitionVersions(long companyId, String keywords, int status, Locale locale, int start, int end, OrderByComparator<KaleoDefinitionVersion> orderByComparator) {
        List<Long> kaleoDefinitionVersionIds = this._getKaleoDefinitionVersionIds(companyId, keywords, status);
        if (kaleoDefinitionVersionIds.isEmpty()) {
            return Collections.emptyList();
        }
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        String[] orderByFields = orderByComparator.getOrderByFields();
        Object orderByField = orderByFields[0];
        if (Objects.equals(orderByField, "modifiedDate")) {
            orderByField = "modified";
        } else if (Objects.equals(orderByField, "title")) {
            orderByField = "title_" + locale.toString();
        }
        searchSearchRequest.addSorts(new Sort[]{this._sorts.field(Field.getSortableFieldName((String)"active"), SortOrder.DESC), this._sorts.field(Field.getSortableFieldName((String)orderByField), orderByComparator.isAscending() ? SortOrder.ASC : SortOrder.DESC)});
        searchSearchRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId)});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        TermsQuery termsQuery = this._queries.terms("entryClassPK");
        termsQuery.addValues((Object[])ArrayUtil.toStringArray(kaleoDefinitionVersionIds));
        booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("entryClassName", (Object)KaleoDefinitionVersion.class.getName()), termsQuery});
        searchSearchRequest.setQuery((Query)booleanQuery);
        if (end != -1 && start != -1) {
            searchSearchRequest.setSize(Integer.valueOf(end - start));
            searchSearchRequest.setStart(Integer.valueOf(start));
        }
        SearchSearchResponse searchSearchResponse = this._searchRequestExecutor.executeSearchRequest(searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        return TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            return (KaleoDefinitionVersion)this.kaleoDefinitionVersionPersistence.fetchByPrimaryKey((Serializable)document.getLong("entryClassPK"));
        });
    }

    public int getLatestKaleoDefinitionVersionsCount(long companyId, String keywords, int status) {
        List<Long> kaleoDefinitionVersionIds = this._getKaleoDefinitionVersionIds(companyId, keywords, status);
        return kaleoDefinitionVersionIds.size();
    }

    private List<Long> _getKaleoDefinitionVersionIds(long companyId, String keywords, int status) {
        ArrayList<Long> kaleoDefinitionVersionIds = new ArrayList<Long>();
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        TermsAggregation termsAggregation = this._aggregations.terms("processDefinitionLatestVersions", Field.getSortableFieldName((String)"name"));
        termsAggregation.setSize(Integer.valueOf(10000));
        TopHitsAggregation topHitsAggregation = this._aggregations.topHits("topHits");
        topHitsAggregation.addSortFields(new Sort[]{this._sorts.field(Field.getSortableFieldName((String)"version"), SortOrder.DESC)});
        topHitsAggregation.setSize(Integer.valueOf(1));
        termsAggregation.addChildrenAggregations(new Aggregation[]{topHitsAggregation});
        searchSearchRequest.addAggregation((Aggregation)termsAggregation);
        searchSearchRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId)});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("entryClassName", (Object)KaleoDefinitionVersion.class.getName()), this._queries.term("scope", (Object)"all")});
        if (Validator.isNotNull((String)keywords)) {
            String[] localizedFieldNames;
            BooleanQuery keywordsBooleanQuery = this._queries.booleanQuery();
            keywordsBooleanQuery.addShouldQueryClauses(new Query[]{this._queries.match("description", (Object)keywords), this._queries.match("name", (Object)keywords)});
            for (String localizedFieldName : localizedFieldNames = this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{"title"}, new SearchContext())) {
                StringQuery stringQuery = this._queries.string(keywords + "*");
                stringQuery.setDefaultField(localizedFieldName);
                keywordsBooleanQuery.addShouldQueryClauses(new Query[]{stringQuery, this._queries.match(localizedFieldName, (Object)keywords)});
            }
            booleanQuery.addMustQueryClauses(new Query[]{keywordsBooleanQuery});
        }
        if (status == 0) {
            booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("active", (Object)1)});
        } else if (status == 2) {
            booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("active", (Object)0)});
        }
        searchSearchRequest.setQuery((Query)booleanQuery);
        searchSearchRequest.setSize(Integer.valueOf(0));
        SearchSearchResponse searchSearchResponse = this._searchRequestExecutor.executeSearchRequest(searchSearchRequest);
        Map aggregationResultsMap = searchSearchResponse.getAggregationResultsMap();
        TermsAggregationResult termsAggregationResult = (TermsAggregationResult)aggregationResultsMap.get("processDefinitionLatestVersions");
        for (Bucket bucket : termsAggregationResult.getBuckets()) {
            TopHitsAggregationResult topHitsAggregationResult = (TopHitsAggregationResult)bucket.getChildAggregationResult("topHits");
            SearchHits searchHits = topHitsAggregationResult.getSearchHits();
            for (SearchHit searchHit : searchHits.getSearchHits()) {
                kaleoDefinitionVersionIds.add(MapUtil.getLong((Map)searchHit.getSourcesMap(), (String)"entryClassPK"));
            }
        }
        return kaleoDefinitionVersionIds;
    }
}

