/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.exportimport.kernel.staging.Staging;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ExceptionRetryAcceptor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.exception.NoSuchInstanceException;
import com.liferay.portal.workflow.kaleo.model.KaleoInstance;
import com.liferay.portal.workflow.kaleo.runtime.util.WorkflowContextUtil;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoInstanceLocalServiceBaseImpl;
import com.liferay.portal.workflow.kaleo.service.persistence.KaleoInstanceQuery;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoInstance"}, service={AopService.class})
public class KaleoInstanceLocalServiceImpl
extends KaleoInstanceLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(KaleoInstanceLocalServiceImpl.class);
    private static final Map<String, String> _fieldNameOrderByCols = HashMapBuilder.put((Object)"completed", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("completed", "String")).put((Object)"completionDate", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("completionDate", "Number")).put((Object)"createDate", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("createDate", "Number")).put((Object)"kaleoInstanceId", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("kaleoInstanceId", "Number")).put((Object)"modifiedDate", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("modified", "Number")).put((Object)"state", (Object)KaleoInstanceLocalServiceImpl._getSortableFieldName("currentKaleoNodeName", "String")).build();
    private static final Map<String, Integer> _fieldNameSortTypes = HashMapBuilder.put((Object)"createDate", (Object)6).put((Object)"modified", (Object)6).put((Object)"completionDate", (Object)6).build();
    @Reference
    private KaleoInstanceTokenLocalService _kaleoInstanceTokenLocalService;
    @Reference
    private KaleoLogLocalService _kaleoLogLocalService;
    @Reference
    private KaleoTaskInstanceTokenLocalService _kaleoTaskInstanceTokenLocalService;
    @Reference
    private KaleoTimerInstanceTokenLocalService _kaleoTimerInstanceTokenLocalService;
    @Reference
    private Staging _staging;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstance addKaleoInstance(long kaleoDefinitionId, long kaleoDefinitionVersionId, String kaleoDefinitionName, int kaleoDefinitionVersion, Map<String, Serializable> workflowContext, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.fetchUser(serviceContext.getUserId());
        if (user == null) {
            user = this._userLocalService.getGuestUser(serviceContext.getCompanyId());
        }
        Date date = new Date();
        long kaleoInstanceId = this.counterLocalService.increment();
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.create(kaleoInstanceId);
        kaleoInstance.setGroupId(this._staging.getLiveGroupId(serviceContext.getScopeGroupId()));
        kaleoInstance.setCompanyId(user.getCompanyId());
        kaleoInstance.setUserId(user.getUserId());
        kaleoInstance.setUserName(user.getFullName());
        kaleoInstance.setCreateDate(date);
        kaleoInstance.setModifiedDate(date);
        kaleoInstance.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoInstance.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoInstance.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstance.setKaleoDefinitionVersion(kaleoDefinitionVersion);
        kaleoInstance.setActive(true);
        kaleoInstance.setClassName((String)((Object)workflowContext.get("entryClassName")));
        if (workflowContext.containsKey("entryClassPK")) {
            kaleoInstance.setClassPK(GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK")))));
        }
        kaleoInstance.setCompleted(false);
        kaleoInstance.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstance completeKaleoInstance(long kaleoInstanceId) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setCompleted(true);
        kaleoInstance.setCompletionDate(new Date());
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    public void deleteCompanyKaleoInstances(long companyId) {
        for (KaleoInstance kaleoInstance : this.kaleoInstancePersistence.findByCompanyId(companyId)) {
            this.kaleoInstanceLocalService.deleteKaleoInstance(kaleoInstance);
        }
        this._kaleoInstanceTokenLocalService.deleteCompanyKaleoInstanceTokens(companyId);
        this._kaleoLogLocalService.deleteCompanyKaleoLogs(companyId);
        this._kaleoTaskInstanceTokenLocalService.deleteCompanyKaleoTaskInstanceTokens(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoInstances(long kaleoDefinitionVersionId) {
        for (KaleoInstance kaleoInstance : this.kaleoInstancePersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId)) {
            this.kaleoInstanceLocalService.deleteKaleoInstance(kaleoInstance);
        }
        this._kaleoInstanceTokenLocalService.deleteKaleoDefinitionVersionKaleoInstanceTokens(kaleoDefinitionVersionId);
        this._kaleoLogLocalService.deleteKaleoDefinitionVersionKaleoLogs(kaleoDefinitionVersionId);
        this._kaleoTaskInstanceTokenLocalService.deleteKaleoDefinitionVersionKaleoTaskInstanceTokens(kaleoDefinitionVersionId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public KaleoInstance deleteKaleoInstance(long kaleoInstanceId) {
        KaleoInstance kaleoInstance = null;
        try {
            kaleoInstance = this.kaleoInstancePersistence.remove(kaleoInstanceId);
        }
        catch (NoSuchInstanceException noSuchInstanceException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchInstanceException);
            }
            return null;
        }
        this._kaleoInstanceTokenLocalService.deleteKaleoInstanceKaleoInstanceTokens(kaleoInstanceId);
        this._kaleoLogLocalService.deleteKaleoInstanceKaleoLogs(kaleoInstanceId);
        this._kaleoTaskInstanceTokenLocalService.deleteKaleoInstanceKaleoTaskInstanceTokens(kaleoInstanceId);
        this._kaleoTimerInstanceTokenLocalService.deleteKaleoTimerInstanceTokens(kaleoInstanceId);
        return kaleoInstance;
    }

    public KaleoInstance fetchKaleoInstance(long kaleoInstanceId, long companyId, long userId) {
        return this.kaleoInstancePersistence.fetchByKII_C_U(kaleoInstanceId, companyId, userId);
    }

    public int getKaleoDefinitionKaleoInstancesCount(long kaleoDefinitionId, boolean completed) {
        return this.kaleoInstancePersistence.countByKDI_C(kaleoDefinitionId, completed);
    }

    public List<KaleoInstance> getKaleoInstances(Long userId, String assetClassName, Long assetClassPK, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) throws PortalException {
        return this._toKaleoInstances(this._search(userId, null, null, null, null, null, null, this._getClassNames(assetClassName), assetClassPK, completed, false, start, end, orderByComparator, serviceContext));
    }

    public List<KaleoInstance> getKaleoInstances(Long userId, String[] assetClassNames, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) throws PortalException {
        return this._toKaleoInstances(this._search(userId, null, null, null, null, null, null, assetClassNames, null, completed, false, start, end, orderByComparator, serviceContext));
    }

    public List<KaleoInstance> getKaleoInstances(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) throws PortalException {
        return this._toKaleoInstances(this._search(null, null, null, null, null, kaleoDefinitionName, kaleoDefinitionVersion, null, null, completed, false, start, end, orderByComparator, serviceContext));
    }

    public int getKaleoInstancesCount(long kaleoDefinitionVersionId, boolean completed) {
        return this.kaleoInstancePersistence.countByKDVI_C(kaleoDefinitionVersionId, completed);
    }

    public int getKaleoInstancesCount(Long userId, String assetClassName, Long assetClassPK, Boolean completed, ServiceContext serviceContext) {
        return this._searchCount(userId, null, null, null, null, null, null, this._getClassNames(assetClassName), assetClassPK, completed, false, serviceContext);
    }

    public int getKaleoInstancesCount(Long userId, String[] assetClassNames, Boolean completed, ServiceContext serviceContext) {
        return this._searchCount(userId, null, null, null, null, null, null, assetClassNames, null, completed, false, serviceContext);
    }

    public int getKaleoInstancesCount(String kaleoDefinitionName, int kaleoDefinitionVersion, boolean completed, ServiceContext serviceContext) {
        return this._searchCount(null, null, null, null, null, kaleoDefinitionName, kaleoDefinitionVersion, null, null, completed, false, serviceContext);
    }

    public List<KaleoInstance> search(Long userId, Boolean active, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        try {
            BaseModelSearchResult<KaleoInstance> baseModelSearchResult = this.searchKaleoInstances(userId, active, assetClassName, assetTitle, assetDescription, nodeName, kaleoDefinitionName, completed, false, start, end, orderByComparator, serviceContext);
            return baseModelSearchResult.getBaseModels();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return Collections.emptyList();
        }
    }

    public int searchCount(Long userId, Boolean active, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, ServiceContext serviceContext) {
        return this._searchCount(userId, active, assetTitle, assetDescription, nodeName, kaleoDefinitionName, null, this._getClassNames(assetClassName), null, completed, false, serviceContext);
    }

    public BaseModelSearchResult<KaleoInstance> searchKaleoInstances(Long userId, Boolean active, String assetClassName, String assetTitle, String assetDescription, String nodeName, String kaleoDefinitionName, Boolean completed, boolean searchByActiveWorkflowHandlers, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) throws PortalException {
        Hits hits = this._search(userId, active, assetTitle, assetDescription, nodeName, kaleoDefinitionName, null, this._getClassNames(assetClassName), null, completed, searchByActiveWorkflowHandlers, start, end, orderByComparator, serviceContext);
        return new BaseModelSearchResult(TransformUtil.transformToList((Object[])hits.getDocs(), document -> this.kaleoInstancePersistence.fetchByPrimaryKey(GetterUtil.getLong((String)document.get("entryClassPK")))), hits.getLength());
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstance updateActive(long userId, long kaleoInstanceId, boolean active) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setUserId(userId);
        kaleoInstance.setActive(active);
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    @Indexable(type=IndexableType.REINDEX)
    public KaleoInstance updateKaleoInstance(long kaleoInstanceId, long rootKaleoInstanceTokenId) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        kaleoInstance.setRootKaleoInstanceTokenId(rootKaleoInstanceTokenId);
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    @Indexable(type=IndexableType.REINDEX)
    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.hibernate.StaleObjectStateException")})
    public KaleoInstance updateKaleoInstance(long kaleoInstanceId, Map<String, Serializable> workflowContext) throws PortalException {
        KaleoInstance kaleoInstance = this.kaleoInstancePersistence.findByPrimaryKey(kaleoInstanceId);
        if (Objects.equals(WorkflowContextUtil.convert(workflowContext), kaleoInstance.getWorkflowContext())) {
            return kaleoInstance;
        }
        kaleoInstance.setWorkflowContext(WorkflowContextUtil.convert(workflowContext));
        return (KaleoInstance)this.kaleoInstancePersistence.update((BaseModel)kaleoInstance);
    }

    private static String _getSortableFieldName(String name, String type) {
        return Field.getSortableFieldName((String)StringBundler.concat((String[])new String[]{name, "_", type}));
    }

    private SearchContext _buildSearchContext(Map<String, Serializable> searchAttributes, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttributes(searchAttributes);
        searchContext.setCompanyId(serviceContext.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{-1L});
        searchContext.setStart(start);
        if (orderByComparator != null) {
            searchContext.setSorts(this._getSortsFromComparator(orderByComparator));
        }
        searchContext.setUserId(serviceContext.getUserId());
        return searchContext;
    }

    private String[] _getClassNames(String className) {
        if (Validator.isNull((String)className)) {
            return null;
        }
        return new String[]{className};
    }

    private Sort[] _getSortsFromComparator(OrderByComparator<KaleoInstance> orderByComparator) {
        if (orderByComparator == null) {
            return null;
        }
        return (Sort[])TransformUtil.transform((Object[])orderByComparator.getOrderByFields(), orderByFieldName -> {
            String fieldName = _fieldNameOrderByCols.getOrDefault(orderByFieldName, (String)orderByFieldName);
            int sortType = _fieldNameSortTypes.getOrDefault(fieldName, 3);
            boolean ascending = orderByComparator.isAscending();
            if (Objects.equals(orderByFieldName, "completed")) {
                ascending = true;
            }
            return new Sort(fieldName, sortType, !ascending);
        }, Sort.class);
    }

    private Hits _search(Long userId, Boolean active, String assetTitle, String assetDescription, String currentKaleoNodeName, String kaleoDefinitionName, Integer kaleoDefinitionVersion, String[] classNames, Long classPK, Boolean completed, boolean searchByActiveWorkflowHandlers, int start, int end, OrderByComparator<KaleoInstance> orderByComparator, ServiceContext serviceContext) throws PortalException {
        KaleoInstanceQuery kaleoInstanceQuery = new KaleoInstanceQuery(serviceContext);
        kaleoInstanceQuery.setActive(active);
        kaleoInstanceQuery.setAssetDescription(assetDescription);
        kaleoInstanceQuery.setAssetTitle(assetTitle);
        kaleoInstanceQuery.setCurrentKaleoNodeName(currentKaleoNodeName);
        kaleoInstanceQuery.setClassNames(classNames);
        kaleoInstanceQuery.setClassPK(classPK);
        kaleoInstanceQuery.setCompleted(completed);
        kaleoInstanceQuery.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstanceQuery.setKaleoDefinitionVersion(kaleoDefinitionVersion);
        kaleoInstanceQuery.setSearchByActiveWorkflowHandlers(searchByActiveWorkflowHandlers);
        kaleoInstanceQuery.setUserId(userId);
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoInstance.class.getName());
        return indexer.search(this._buildSearchContext(HashMapBuilder.put((Object)"kaleoInstanceQuery", (Object)kaleoInstanceQuery).build(), start, end, orderByComparator, serviceContext));
    }

    private int _searchCount(Long userId, Boolean active, String assetTitle, String assetDescription, String currentKaleoNodeName, String kaleoDefinitionName, Integer kaleoDefinitionVersion, String[] classNames, Long classPK, Boolean completed, boolean searchByActiveWorkflowHandlers, ServiceContext serviceContext) {
        KaleoInstanceQuery kaleoInstanceQuery = new KaleoInstanceQuery(serviceContext);
        kaleoInstanceQuery.setActive(active);
        kaleoInstanceQuery.setAssetDescription(assetDescription);
        kaleoInstanceQuery.setAssetTitle(assetTitle);
        kaleoInstanceQuery.setCurrentKaleoNodeName(currentKaleoNodeName);
        kaleoInstanceQuery.setClassNames(classNames);
        kaleoInstanceQuery.setClassPK(classPK);
        kaleoInstanceQuery.setCompleted(completed);
        kaleoInstanceQuery.setKaleoDefinitionName(kaleoDefinitionName);
        kaleoInstanceQuery.setKaleoDefinitionVersion(kaleoDefinitionVersion);
        kaleoInstanceQuery.setSearchByActiveWorkflowHandlers(searchByActiveWorkflowHandlers);
        kaleoInstanceQuery.setUserId(userId);
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)KaleoInstance.class.getName());
            return (int)indexer.searchCount(this._buildSearchContext(HashMapBuilder.put((Object)"kaleoInstanceQuery", (Object)kaleoInstanceQuery).build(), -1, -1, null, serviceContext));
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return 0;
        }
    }

    private List<KaleoInstance> _toKaleoInstances(Hits hits) {
        return TransformUtil.transformToList((Object[])hits.getDocs(), document -> this.kaleoInstancePersistence.fetchByPrimaryKey(GetterUtil.getLong((String)document.get("entryClassPK"))));
    }
}

