/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.workflow.kaleo.definition.TaskForm;
import com.liferay.portal.workflow.kaleo.definition.TaskFormReference;
import com.liferay.portal.workflow.kaleo.model.KaleoTask;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskForm;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTaskFormLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTaskForm"}, service={AopService.class})
public class KaleoTaskFormLocalServiceImpl
extends KaleoTaskFormLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public KaleoTaskForm addKaleoTaskForm(long kaleoDefinitionId, long kaleoDefinitionVersionId, long kaleoNodeId, KaleoTask kaleoTask, TaskForm taskForm, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoTaskFormId = this.counterLocalService.increment();
        KaleoTaskForm kaleoTaskForm = this.kaleoTaskFormPersistence.create(kaleoTaskFormId);
        kaleoTaskForm.setGroupId(kaleoTask.getGroupId());
        kaleoTaskForm.setCompanyId(user.getCompanyId());
        kaleoTaskForm.setUserId(user.getUserId());
        kaleoTaskForm.setUserName(user.getFullName());
        kaleoTaskForm.setCreateDate(date);
        kaleoTaskForm.setModifiedDate(date);
        kaleoTaskForm.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoTaskForm.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoTaskForm.setKaleoNodeId(kaleoNodeId);
        kaleoTaskForm.setKaleoTaskId(kaleoTask.getKaleoTaskId());
        kaleoTaskForm.setKaleoTaskName(kaleoTask.getName());
        kaleoTaskForm.setName(taskForm.getName());
        kaleoTaskForm.setDescription(taskForm.getDescription());
        kaleoTaskForm.setFormDefinition(taskForm.getFormDefinition());
        kaleoTaskForm.setMetadata(taskForm.getMetadata());
        kaleoTaskForm.setPriority(taskForm.getPriority());
        TaskFormReference taskFormReference = taskForm.getTaskFormReference();
        kaleoTaskForm.setFormCompanyId(taskFormReference.getCompanyId());
        kaleoTaskForm.setFormGroupId(taskFormReference.getGroupId());
        kaleoTaskForm.setFormId(taskFormReference.getFormId());
        kaleoTaskForm.setFormUuid(taskFormReference.getFormUuid());
        return (KaleoTaskForm)this.kaleoTaskFormPersistence.update((BaseModel)kaleoTaskForm);
    }

    public void deleteCompanyKaleoTaskForms(long companyId) {
        this.kaleoTaskFormPersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTaskForms(long kaleoDefinitionVersionId) {
        this.kaleoTaskFormPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    @Override
    public KaleoTaskForm fetchKaleoTaskForm(long kaleoTaskFormId) {
        return this.kaleoTaskFormPersistence.fetchByPrimaryKey(kaleoTaskFormId);
    }

    public List<KaleoTaskForm> getKaleoTaskForms(long kaleoTaskId) throws PortalException {
        return this.kaleoTaskFormPersistence.findByKaleoTaskId(kaleoTaskId);
    }
}

