/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.workflow.kaleo.definition.Action;
import com.liferay.portal.workflow.kaleo.definition.Assignment;
import com.liferay.portal.workflow.kaleo.definition.DelayDuration;
import com.liferay.portal.workflow.kaleo.definition.DurationScale;
import com.liferay.portal.workflow.kaleo.definition.Notification;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.model.KaleoTimer;
import com.liferay.portal.workflow.kaleo.service.KaleoActionLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoNotificationLocalService;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTimerLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTimer"}, service={AopService.class})
public class KaleoTimerLocalServiceImpl
extends KaleoTimerLocalServiceBaseImpl {
    @Reference
    private KaleoActionLocalService _kaleoActionLocalService;
    @Reference
    private KaleoNotificationLocalService _kaleoNotificationLocalService;
    @Reference
    private KaleoTaskAssignmentLocalService _kaleoTaskAssignmentLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public KaleoTimer addKaleoTimer(String kaleoClassName, long kaleoClassPK, long kaleoDefinitionId, long kaleoDefinitionVersionId, Timer timer, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoTimerId = this.counterLocalService.increment();
        KaleoTimer kaleoTimer = this.kaleoTimerPersistence.create(kaleoTimerId);
        kaleoTimer.setCompanyId(user.getCompanyId());
        kaleoTimer.setUserId(user.getUserId());
        kaleoTimer.setUserName(user.getFullName());
        kaleoTimer.setCreateDate(date);
        kaleoTimer.setModifiedDate(date);
        kaleoTimer.setKaleoClassName(kaleoClassName);
        kaleoTimer.setKaleoClassPK(kaleoClassPK);
        kaleoTimer.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoTimer.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoTimer.setName(timer.getName());
        kaleoTimer.setBlocking(timer.isBlocking());
        DelayDuration delayDuration = timer.getDelayDuration();
        kaleoTimer.setDuration(delayDuration.getDuration());
        DurationScale durationScale = delayDuration.getDurationScale();
        kaleoTimer.setScale(durationScale.getValue());
        DelayDuration recurrenceDelayDuration = timer.getRecurrence();
        if (recurrenceDelayDuration != null) {
            kaleoTimer.setRecurrenceDuration(recurrenceDelayDuration.getDuration());
            durationScale = recurrenceDelayDuration.getDurationScale();
            kaleoTimer.setRecurrenceScale(durationScale.getValue());
        }
        kaleoTimer = (KaleoTimer)this.kaleoTimerPersistence.update((BaseModel)kaleoTimer);
        Set actions = timer.getActions();
        for (Object action : actions) {
            this._kaleoActionLocalService.addKaleoAction(KaleoTimer.class.getName(), kaleoTimerId, kaleoDefinitionId, kaleoDefinitionVersionId, timer.getName(), (Action)action, serviceContext);
        }
        Set reassignments = timer.getReassignments();
        for (Assignment reassignment : reassignments) {
            this._kaleoTaskAssignmentLocalService.addKaleoTaskAssignment(KaleoTimer.class.getName(), kaleoTimerId, kaleoDefinitionId, kaleoDefinitionVersionId, reassignment, serviceContext);
        }
        Set notifications = timer.getNotifications();
        for (Notification notification : notifications) {
            this._kaleoNotificationLocalService.addKaleoNotification(KaleoTimer.class.getName(), kaleoTimerId, kaleoDefinitionId, kaleoDefinitionVersionId, timer.getName(), notification, serviceContext);
        }
        return kaleoTimer;
    }

    public List<KaleoTimer> getKaleoTimers(String kaleoClassName, long kaleoClassPK) {
        return this.kaleoTimerPersistence.findByKCN_KCPK(kaleoClassName, kaleoClassPK);
    }

    public List<KaleoTimer> getKaleoTimers(String kaleoClassName, long kaleoClassPK, boolean blocking) {
        return this.kaleoTimerPersistence.findByKCN_KCPK_Blocking(kaleoClassName, kaleoClassPK, blocking);
    }
}

