/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.workflow.kaleo.definition.Timer;
import com.liferay.portal.workflow.kaleo.definition.Transition;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.service.KaleoTimerLocalService;
import com.liferay.portal.workflow.kaleo.service.base.KaleoTransitionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.workflow.kaleo.model.KaleoTransition"}, service={AopService.class})
public class KaleoTransitionLocalServiceImpl
extends KaleoTransitionLocalServiceBaseImpl {
    @Reference
    private KaleoTimerLocalService _kaleoTimerLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public KaleoTransition addKaleoTransition(long kaleoDefinitionId, long kaleoDefinitionVersionId, long kaleoNodeId, Transition transition, KaleoNode sourceKaleoNode, KaleoNode targetKaleoNode, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(serviceContext.getGuestOrUserId());
        Date date = new Date();
        long kaleoTransitionId = this.counterLocalService.increment();
        KaleoTransition kaleoTransition = this.kaleoTransitionPersistence.create(kaleoTransitionId);
        kaleoTransition.setCompanyId(user.getCompanyId());
        kaleoTransition.setUserId(user.getUserId());
        kaleoTransition.setUserName(user.getFullName());
        kaleoTransition.setCreateDate(date);
        kaleoTransition.setModifiedDate(date);
        kaleoTransition.setKaleoDefinitionId(kaleoDefinitionId);
        kaleoTransition.setKaleoDefinitionVersionId(kaleoDefinitionVersionId);
        kaleoTransition.setKaleoNodeId(kaleoNodeId);
        kaleoTransition.setName(transition.getName());
        kaleoTransition.setLabelMap(transition.getLabelMap());
        kaleoTransition.setSourceKaleoNodeId(sourceKaleoNode.getKaleoNodeId());
        kaleoTransition.setSourceKaleoNodeName(sourceKaleoNode.getName());
        kaleoTransition.setTargetKaleoNodeId(targetKaleoNode.getKaleoNodeId());
        kaleoTransition.setTargetKaleoNodeName(targetKaleoNode.getName());
        kaleoTransition.setDefaultTransition(transition.isDefault());
        kaleoTransition = (KaleoTransition)this.kaleoTransitionPersistence.update((BaseModel)kaleoTransition);
        Timer timer = transition.getTimer();
        if (timer != null) {
            this._kaleoTimerLocalService.addKaleoTimer(KaleoTransition.class.getName(), kaleoTransitionId, kaleoDefinitionId, kaleoDefinitionVersionId, timer, serviceContext);
        }
        return kaleoTransition;
    }

    public void deleteCompanyKaleoTransitions(long companyId) {
        this.kaleoTransitionPersistence.removeByCompanyId(companyId);
    }

    public void deleteKaleoDefinitionVersionKaleoTransitions(long kaleoDefinitionVersionId) {
        this.kaleoTransitionPersistence.removeByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public KaleoTransition getDefaultKaleoTransition(long kaleoNodeId) throws PortalException {
        return this.kaleoTransitionPersistence.findByKNI_DT(kaleoNodeId, true);
    }

    public List<KaleoTransition> getKaleoDefinitionVersionKaleoTransitions(long kaleoDefinitionVersionId) {
        return this.kaleoTransitionPersistence.findByKaleoDefinitionVersionId(kaleoDefinitionVersionId);
    }

    public KaleoTransition getKaleoTransition(long kaleoNodeId, String name) throws PortalException {
        return this.kaleoTransitionPersistence.findByKNI_N(kaleoNodeId, name);
    }

    public List<KaleoTransition> getKaleoTransitions(long kaleoNodeId) {
        return this.kaleoTransitionPersistence.findByKaleoNodeId(kaleoNodeId);
    }

    public int getKaleoTransitionsCount(long kaleoNodeId) {
        return this.kaleoTransitionPersistence.countByKaleoNodeId(kaleoNodeId);
    }
}

