/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.workflow.kaleo.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.workflow.kaleo.model.KaleoLog;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.uad.constants.KaleoUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the kaleo log UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link KaleoLogUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseKaleoLogUADAnonymizer
	extends DynamicQueryUADAnonymizer<KaleoLog> {

	@Override
	public void autoAnonymize(
			KaleoLog kaleoLog, long userId, User anonymousUser)
		throws PortalException {

		if (kaleoLog.getUserId() == userId) {
			kaleoLog.setUserId(anonymousUser.getUserId());
			kaleoLog.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(kaleoLog, anonymousUser);
		}

		kaleoLogLocalService.updateKaleoLog(kaleoLog);
	}

	@Override
	public void delete(KaleoLog kaleoLog) throws PortalException {
		kaleoLogLocalService.deleteKaleoLog(kaleoLog);
	}

	@Override
	public Class<KaleoLog> getTypeClass() {
		return KaleoLog.class;
	}

	protected void autoAnonymizeAssetEntry(
		KaleoLog kaleoLog, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(kaleoLog);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return kaleoLogLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return KaleoUADConstants.USER_ID_FIELD_NAMES_KALEO_LOG;
	}

	protected AssetEntry fetchAssetEntry(KaleoLog kaleoLog) {
		return assetEntryLocalService.fetchEntry(
			KaleoLog.class.getName(), kaleoLog.getKaleoLogId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected KaleoLogLocalService kaleoLogLocalService;

}