/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.uad.constants.KaleoUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKaleoInstanceTokenUADAnonymizer
extends DynamicQueryUADAnonymizer<KaleoInstanceToken> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected KaleoInstanceTokenLocalService kaleoInstanceTokenLocalService;

    public void autoAnonymize(KaleoInstanceToken kaleoInstanceToken, long userId, User anonymousUser) throws PortalException {
        if (kaleoInstanceToken.getUserId() == userId) {
            kaleoInstanceToken.setUserId(anonymousUser.getUserId());
            kaleoInstanceToken.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(kaleoInstanceToken, anonymousUser);
        }
        this.kaleoInstanceTokenLocalService.updateKaleoInstanceToken(kaleoInstanceToken);
    }

    public void delete(KaleoInstanceToken kaleoInstanceToken) throws PortalException {
        this.kaleoInstanceTokenLocalService.deleteKaleoInstanceToken(kaleoInstanceToken);
    }

    public Class<KaleoInstanceToken> getTypeClass() {
        return KaleoInstanceToken.class;
    }

    protected void autoAnonymizeAssetEntry(KaleoInstanceToken kaleoInstanceToken, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(kaleoInstanceToken);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.kaleoInstanceTokenLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return KaleoUADConstants.USER_ID_FIELD_NAMES_KALEO_INSTANCE_TOKEN;
    }

    protected AssetEntry fetchAssetEntry(KaleoInstanceToken kaleoInstanceToken) {
        return this.assetEntryLocalService.fetchEntry(KaleoInstanceToken.class.getName(), kaleoInstanceToken.getKaleoInstanceTokenId());
    }
}

