/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.workflow.kaleo.model.KaleoLog;
import com.liferay.portal.workflow.kaleo.service.KaleoLogLocalService;
import com.liferay.portal.workflow.kaleo.uad.constants.KaleoUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKaleoLogUADAnonymizer
extends DynamicQueryUADAnonymizer<KaleoLog> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected KaleoLogLocalService kaleoLogLocalService;

    public void autoAnonymize(KaleoLog kaleoLog, long userId, User anonymousUser) throws PortalException {
        if (kaleoLog.getUserId() == userId) {
            kaleoLog.setUserId(anonymousUser.getUserId());
            kaleoLog.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(kaleoLog, anonymousUser);
        }
        this.kaleoLogLocalService.updateKaleoLog(kaleoLog);
    }

    public void delete(KaleoLog kaleoLog) throws PortalException {
        this.kaleoLogLocalService.deleteKaleoLog(kaleoLog);
    }

    public Class<KaleoLog> getTypeClass() {
        return KaleoLog.class;
    }

    protected void autoAnonymizeAssetEntry(KaleoLog kaleoLog, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(kaleoLog);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.kaleoLogLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return KaleoUADConstants.USER_ID_FIELD_NAMES_KALEO_LOG;
    }

    protected AssetEntry fetchAssetEntry(KaleoLog kaleoLog) {
        return this.assetEntryLocalService.fetchEntry(KaleoLog.class.getName(), kaleoLog.getKaleoLogId());
    }
}

