/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskAssignmentInstance;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskAssignmentInstanceLocalService;
import com.liferay.portal.workflow.kaleo.uad.constants.KaleoUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKaleoTaskAssignmentInstanceUADAnonymizer
extends DynamicQueryUADAnonymizer<KaleoTaskAssignmentInstance> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected KaleoTaskAssignmentInstanceLocalService kaleoTaskAssignmentInstanceLocalService;

    public void autoAnonymize(KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance, long userId, User anonymousUser) throws PortalException {
        if (kaleoTaskAssignmentInstance.getUserId() == userId) {
            kaleoTaskAssignmentInstance.setUserId(anonymousUser.getUserId());
            kaleoTaskAssignmentInstance.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(kaleoTaskAssignmentInstance, anonymousUser);
        }
        this.kaleoTaskAssignmentInstanceLocalService.updateKaleoTaskAssignmentInstance(kaleoTaskAssignmentInstance);
    }

    public void delete(KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance) throws PortalException {
        this.kaleoTaskAssignmentInstanceLocalService.deleteKaleoTaskAssignmentInstance(kaleoTaskAssignmentInstance);
    }

    public Class<KaleoTaskAssignmentInstance> getTypeClass() {
        return KaleoTaskAssignmentInstance.class;
    }

    protected void autoAnonymizeAssetEntry(KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(kaleoTaskAssignmentInstance);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.kaleoTaskAssignmentInstanceLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return KaleoUADConstants.USER_ID_FIELD_NAMES_KALEO_TASK_ASSIGNMENT_INSTANCE;
    }

    protected AssetEntry fetchAssetEntry(KaleoTaskAssignmentInstance kaleoTaskAssignmentInstance) {
        return this.assetEntryLocalService.fetchEntry(KaleoTaskAssignmentInstance.class.getName(), kaleoTaskAssignmentInstance.getKaleoTaskAssignmentInstanceId());
    }
}

