/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.workflow.kaleo.model.KaleoTaskInstanceToken;
import com.liferay.portal.workflow.kaleo.service.KaleoTaskInstanceTokenLocalService;
import com.liferay.portal.workflow.kaleo.uad.constants.KaleoUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseKaleoTaskInstanceTokenUADAnonymizer
extends DynamicQueryUADAnonymizer<KaleoTaskInstanceToken> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected KaleoTaskInstanceTokenLocalService kaleoTaskInstanceTokenLocalService;

    public void autoAnonymize(KaleoTaskInstanceToken kaleoTaskInstanceToken, long userId, User anonymousUser) throws PortalException {
        if (kaleoTaskInstanceToken.getUserId() == userId) {
            kaleoTaskInstanceToken.setUserId(anonymousUser.getUserId());
            kaleoTaskInstanceToken.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(kaleoTaskInstanceToken, anonymousUser);
        }
        if (kaleoTaskInstanceToken.getCompletionUserId() == userId) {
            kaleoTaskInstanceToken.setCompletionUserId(anonymousUser.getUserId());
        }
        this.kaleoTaskInstanceTokenLocalService.updateKaleoTaskInstanceToken(kaleoTaskInstanceToken);
    }

    public void delete(KaleoTaskInstanceToken kaleoTaskInstanceToken) throws PortalException {
        this.kaleoTaskInstanceTokenLocalService.deleteKaleoTaskInstanceToken(kaleoTaskInstanceToken);
    }

    public Class<KaleoTaskInstanceToken> getTypeClass() {
        return KaleoTaskInstanceToken.class;
    }

    protected void autoAnonymizeAssetEntry(KaleoTaskInstanceToken kaleoTaskInstanceToken, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(kaleoTaskInstanceToken);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.kaleoTaskInstanceTokenLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return KaleoUADConstants.USER_ID_FIELD_NAMES_KALEO_TASK_INSTANCE_TOKEN;
    }

    protected AssetEntry fetchAssetEntry(KaleoTaskInstanceToken kaleoTaskInstanceToken) {
        return this.assetEntryLocalService.fetchEntry(KaleoTaskInstanceToken.class.getName(), kaleoTaskInstanceToken.getKaleoTaskInstanceTokenId());
    }
}

