/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.workflow.uad.constants.PortalWorkflowUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseWorkflowDefinitionLinkUADAnonymizer
extends DynamicQueryUADAnonymizer<WorkflowDefinitionLink> {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService;

    public void autoAnonymize(WorkflowDefinitionLink workflowDefinitionLink, long userId, User anonymousUser) throws PortalException {
        if (workflowDefinitionLink.getUserId() == userId) {
            workflowDefinitionLink.setUserId(anonymousUser.getUserId());
            workflowDefinitionLink.setUserName(anonymousUser.getFullName());
            this.autoAnonymizeAssetEntry(workflowDefinitionLink, anonymousUser);
        }
        this.workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(workflowDefinitionLink);
    }

    public void delete(WorkflowDefinitionLink workflowDefinitionLink) throws PortalException {
        this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
    }

    public Class<WorkflowDefinitionLink> getTypeClass() {
        return WorkflowDefinitionLink.class;
    }

    protected void autoAnonymizeAssetEntry(WorkflowDefinitionLink workflowDefinitionLink, User anonymousUser) {
        AssetEntry assetEntry = this.fetchAssetEntry(workflowDefinitionLink);
        if (assetEntry != null) {
            assetEntry.setUserId(anonymousUser.getUserId());
            assetEntry.setUserName(anonymousUser.getFullName());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
    }

    protected ActionableDynamicQuery doGetActionableDynamicQuery() {
        return this.workflowDefinitionLinkLocalService.getActionableDynamicQuery();
    }

    protected String[] doGetUserIdFieldNames() {
        return PortalWorkflowUADConstants.USER_ID_FIELD_NAMES_WORKFLOW_DEFINITION_LINK;
    }

    protected AssetEntry fetchAssetEntry(WorkflowDefinitionLink workflowDefinitionLink) {
        return this.assetEntryLocalService.fetchEntry(WorkflowDefinitionLink.class.getName(), workflowDefinitionLink.getWorkflowDefinitionLinkId());
    }
}

