/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.workflow.uad.anonymizer;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.workflow.uad.constants.PortalWorkflowUADConstants;
import com.liferay.user.associated.data.anonymizer.DynamicQueryUADAnonymizer;

import org.osgi.service.component.annotations.Reference;

/**
 * Provides the base implementation for the workflow definition link UAD anonymizer.
 *
 * <p>
 * This implementation exists only as a container for the default methods
 * generated by ServiceBuilder. All custom service methods should be put in
 * {@link WorkflowDefinitionLinkUADAnonymizer}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public abstract class BaseWorkflowDefinitionLinkUADAnonymizer
	extends DynamicQueryUADAnonymizer<WorkflowDefinitionLink> {

	@Override
	public void autoAnonymize(
			WorkflowDefinitionLink workflowDefinitionLink, long userId,
			User anonymousUser)
		throws PortalException {

		if (workflowDefinitionLink.getUserId() == userId) {
			workflowDefinitionLink.setUserId(anonymousUser.getUserId());
			workflowDefinitionLink.setUserName(anonymousUser.getFullName());

			autoAnonymizeAssetEntry(workflowDefinitionLink, anonymousUser);
		}

		workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(
			workflowDefinitionLink);
	}

	@Override
	public void delete(WorkflowDefinitionLink workflowDefinitionLink)
		throws PortalException {

		workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(
			workflowDefinitionLink);
	}

	@Override
	public Class<WorkflowDefinitionLink> getTypeClass() {
		return WorkflowDefinitionLink.class;
	}

	protected void autoAnonymizeAssetEntry(
		WorkflowDefinitionLink workflowDefinitionLink, User anonymousUser) {

		AssetEntry assetEntry = fetchAssetEntry(workflowDefinitionLink);

		if (assetEntry != null) {
			assetEntry.setUserId(anonymousUser.getUserId());
			assetEntry.setUserName(anonymousUser.getFullName());

			assetEntryLocalService.updateAssetEntry(assetEntry);
		}
	}

	@Override
	protected ActionableDynamicQuery doGetActionableDynamicQuery() {
		return workflowDefinitionLinkLocalService.getActionableDynamicQuery();
	}

	@Override
	protected String[] doGetUserIdFieldNames() {
		return PortalWorkflowUADConstants.
			USER_ID_FIELD_NAMES_WORKFLOW_DEFINITION_LINK;
	}

	protected AssetEntry fetchAssetEntry(
		WorkflowDefinitionLink workflowDefinitionLink) {

		return assetEntryLocalService.fetchEntry(
			WorkflowDefinitionLink.class.getName(),
			workflowDefinitionLink.getWorkflowDefinitionLinkId());
	}

	@Reference
	protected AssetEntryLocalService assetEntryLocalService;

	@Reference
	protected WorkflowDefinitionLinkLocalService
		workflowDefinitionLinkLocalService;

}