/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.configuration.icon.maximize.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={PortletConfigurationIcon.class})
public class MaximizePortletConfigurationIcon
extends BasePortletConfigurationIcon {
    private static final Log _log = LogFactoryUtil.getLog(MaximizePortletConfigurationIcon.class);

    public String getCssClass() {
        return "portlet-maximize portlet-maximize-icon";
    }

    public String getMessage(PortletRequest portletRequest) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)"maximize");
    }

    public String getMethod() {
        return "get";
    }

    public String getOnClick(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return StringBundler.concat((String[])new String[]{"submitForm(document.hrefFm, '", HtmlUtil.escapeJS((String)portletDisplay.getURLMax()), "'); return false;"});
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        return portletDisplay.getURLMax();
    }

    public double getWeight() {
        return 7.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!GetterUtil.getBoolean((String)themeDisplay.getThemeSetting("show-maximize-minimize-application-links"))) {
            return false;
        }
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypePortlet()) {
            return false;
        }
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        LayoutTypeController layoutTypeController = layoutTypePortlet.getLayoutTypeController();
        if (layoutTypeController.isFullPageDisplayable()) {
            return false;
        }
        Portlet portlet = (Portlet)portletRequest.getAttribute("RENDER_PORTLET");
        if (!portlet.hasWindowState(portletRequest.getResponseContentType(), WindowState.MAXIMIZED)) {
            return false;
        }
        Group group = themeDisplay.getScopeGroup();
        return themeDisplay.isSignedIn() && (!group.hasStagingGroup() || group.isStagingGroup()) && this.hasUpdateLayoutPermission(themeDisplay) || PropsValues.LAYOUT_GUEST_SHOW_MAX_ICON;
    }

    public boolean isToolTip() {
        return false;
    }

    protected boolean hasUpdateLayoutPermission(ThemeDisplay themeDisplay) {
        try {
            return LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)themeDisplay.getLayout(), (String)"UPDATE");
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
            return false;
        }
    }
}

