/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.configuration.web.internal.display.context;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.ResourcePrimKeyException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProviderUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.configuration.web.internal.configuration.RoleVisibilityConfiguration;
import com.liferay.portlet.rolesadmin.search.RoleSearch;
import com.liferay.portlet.rolesadmin.search.RoleSearchTerms;
import com.liferay.sites.kernel.util.SitesUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.WindowStateException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class PortletConfigurationPermissionsDisplayContext {
    private List<String> _actions;
    private Group _group;
    private final long _groupId;
    private List<String> _guestUnsupportedActions;
    private final HttpServletRequest _httpServletRequest;
    private String _modelResource;
    private String _modelResourceDescription;
    private String _portletResource;
    private final RenderRequest _renderRequest;
    private Resource _resource;
    private Long _resourceGroupId;
    private String _resourcePrimKey;
    private String _returnToFullPageURL;
    private SearchContainer _roleSearchContainer;
    private int[] _roleTypes;
    private String _roleTypesParam;
    private final Layout _selLayout;
    private String _selResource;
    private String _selResourceDescription;

    public PortletConfigurationPermissionsDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest) throws PortalException {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        long groupId = this._getResourceGroupId();
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Layout selLayout = null;
        if (Objects.equals(this.getModelResource(), Layout.class.getName())) {
            selLayout = LayoutLocalServiceUtil.getLayout((long)GetterUtil.getLong((String)this.getResourcePrimKey()));
            group = selLayout.getGroup();
            groupId = group.getGroupId();
        }
        this._selLayout = selLayout;
        this._group = group;
        this._groupId = groupId;
    }

    public List<String> getActions() throws PortalException {
        long modelResourceRoleId;
        Role modelResourceRole;
        String name;
        if (this._actions != null) {
            return this._actions;
        }
        ArrayList actions = ResourceActionsUtil.getResourceActions((String)this._getPortletResource(), (String)this.getModelResource());
        if (Objects.equals(this.getModelResource(), Group.class.getName())) {
            long modelResourceGroupId = GetterUtil.getLong((String)this.getResourcePrimKey());
            Group modelResourceGroup = GroupLocalServiceUtil.getGroup((long)modelResourceGroupId);
            if (modelResourceGroup.isLayoutPrototype() || modelResourceGroup.isLayoutSetPrototype() || modelResourceGroup.isUserGroup()) {
                actions = new ArrayList(actions);
                actions.remove("ADD_LAYOUT_BRANCH");
                actions.remove("ADD_LAYOUT_SET_BRANCH");
                actions.remove("ASSIGN_MEMBERS");
                actions.remove("ASSIGN_USER_ROLES");
                actions.remove("MANAGE_ANNOUNCEMENTS");
                actions.remove("MANAGE_STAGING");
                actions.remove("MANAGE_TEAMS");
                actions.remove("PUBLISH_STAGING");
                actions.remove("VIEW_MEMBERS");
                actions.remove("VIEW_STAGING");
            }
        } else if (Objects.equals(this.getModelResource(), Role.class.getName()) && ((name = (modelResourceRole = RoleLocalServiceUtil.getRole((long)(modelResourceRoleId = GetterUtil.getLong((String)this.getResourcePrimKey())))).getName()).equals("Guest") || name.equals("User"))) {
            actions = new ArrayList(actions);
            actions.remove("ASSIGN_MEMBERS");
            actions.remove("DEFINE_PERMISSIONS");
            actions.remove("DELETE");
            actions.remove("PERMISSIONS");
            actions.remove("UPDATE");
            actions.remove("VIEW");
        }
        this._actions = actions;
        return this._actions;
    }

    public String getClearResultsURL() throws Exception {
        PortletURL clearResultsURL = this.getIteratorURL();
        clearResultsURL.setParameter("keywords", "");
        return clearResultsURL.toString();
    }

    public PortletURL getDefinePermissionsURL() throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)PortletProviderUtil.getPortletURL((HttpServletRequest)this._httpServletRequest, (String)Role.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        liferayPortletURL.setParameter("cmd", "view");
        liferayPortletURL.setParameter("backURL", themeDisplay.getURLCurrent());
        liferayPortletURL.setPortletMode(PortletMode.VIEW);
        liferayPortletURL.setRefererPlid(themeDisplay.getPlid());
        liferayPortletURL.setWindowState(LiferayWindowState.POP_UP);
        return liferayPortletURL;
    }

    public String getGroupDescriptiveName() throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._group.getDescriptiveName(themeDisplay.getLocale());
    }

    public long getGroupId() {
        return this._groupId;
    }

    public List<String> getGuestUnsupportedActions() {
        if (this._guestUnsupportedActions != null) {
            return this._guestUnsupportedActions;
        }
        ArrayList<String> guestUnsupportedActions = ResourceActionsUtil.getResourceGuestUnsupportedActions((String)this._getPortletResource(), (String)this.getModelResource());
        if (this._selLayout != null && this._group.isGuest() && SitesUtil.isFirstLayout((long)this._selLayout.getGroupId(), (boolean)this._selLayout.isPrivateLayout(), (long)this._selLayout.getLayoutId())) {
            guestUnsupportedActions = new ArrayList<String>(guestUnsupportedActions);
            guestUnsupportedActions.add("VIEW");
        }
        this._guestUnsupportedActions = guestUnsupportedActions;
        return this._guestUnsupportedActions;
    }

    public PortletURL getIteratorURL() throws Exception {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_portlet_configuration_web_portlet_PortletConfigurationPortlet", (String)"RENDER_PHASE");
        portletURL.setParameter("mvcPath", "/edit_permissions.jsp");
        portletURL.setParameter("returnToFullPageURL", this._getReturnToFullPageURL());
        portletURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
        portletURL.setParameter("portletResource", this._getPortletResource());
        portletURL.setParameter("modelResource", this.getModelResource());
        portletURL.setParameter("resourceGroupId", String.valueOf(this._getResourceGroupId()));
        portletURL.setParameter("resourcePrimKey", this.getResourcePrimKey());
        portletURL.setParameter("roleTypes", this._getRoleTypesParam());
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return portletURL;
    }

    public String getModelResource() {
        if (this._modelResource != null) {
            return this._modelResource;
        }
        this._modelResource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"modelResource");
        return this._modelResource;
    }

    public String getModelResourceDescription() {
        if (this._modelResourceDescription != null) {
            return this._modelResourceDescription;
        }
        this._modelResourceDescription = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"modelResourceDescription");
        return this._modelResourceDescription;
    }

    public Resource getResource() throws PortalException {
        if (this._resource != null) {
            return this._resource;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount((long)themeDisplay.getCompanyId(), (String)this.getSelResource(), (int)4, (String)this.getResourcePrimKey());
        if (count == 0) {
            boolean portletActions = Validator.isNull((String)this.getModelResource());
            ResourceLocalServiceUtil.addResources((long)themeDisplay.getCompanyId(), (long)this.getGroupId(), (long)0L, (String)this.getSelResource(), (String)this.getResourcePrimKey(), (boolean)portletActions, (boolean)true, (boolean)true);
        }
        this._resource = ResourceLocalServiceUtil.getResource((long)themeDisplay.getCompanyId(), (String)this.getSelResource(), (int)4, (String)this.getResourcePrimKey());
        return this._resource;
    }

    public String getResourcePrimKey() throws ResourcePrimKeyException {
        if (this._resourcePrimKey != null) {
            return this._resourcePrimKey;
        }
        this._resourcePrimKey = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"resourcePrimKey");
        if (Validator.isNull((String)this._resourcePrimKey)) {
            throw new ResourcePrimKeyException();
        }
        return this._resourcePrimKey;
    }

    public SearchContainer getRoleSearchContainer() throws Exception {
        Group resourceLayoutGroup;
        long resourcePlid;
        Layout resourceLayout;
        String resourcePrimKey;
        int pos;
        long modelResourceRoleId;
        Role modelResourceRole;
        boolean filterGroupRoles;
        if (this._roleSearchContainer != null) {
            return this._roleSearchContainer;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        RoleSearch roleSearchContainer = new RoleSearch((PortletRequest)this._renderRequest, this.getIteratorURL());
        RoleSearchTerms searchTerms = (RoleSearchTerms)roleSearchContainer.getSearchTerms();
        boolean bl = filterGroupRoles = !ResourceActionsUtil.isPortalModelResource((String)this.getModelResource());
        if (Objects.equals(this.getModelResource(), Role.class.getName()) && ((modelResourceRole = RoleLocalServiceUtil.getRole((long)(modelResourceRoleId = GetterUtil.getLong((String)this.getResourcePrimKey())))).getType() == 3 || modelResourceRole.getType() == 2)) {
            filterGroupRoles = true;
        }
        modelResourceRoleId = 0L;
        if (Objects.equals(this.getModelResource(), Role.class.getName())) {
            modelResourceRoleId = GetterUtil.getLong((String)this.getResourcePrimKey());
        }
        boolean filterGuestRole = false;
        boolean permissionCheckGuestEnabled = PropsValues.PERMISSIONS_CHECK_GUEST_ENABLED;
        if (Objects.equals(this.getModelResource(), Layout.class.getName())) {
            Group resourceLayoutGroup2;
            Layout resourceLayout2 = LayoutLocalServiceUtil.getLayout((long)GetterUtil.getLong((String)this.getResourcePrimKey()));
            if (resourceLayout2.isPrivateLayout() && !(resourceLayoutGroup2 = resourceLayout2.getGroup()).isLayoutSetPrototype() && !permissionCheckGuestEnabled) {
                filterGuestRole = true;
            }
        } else if (Validator.isNotNull((String)this._getPortletResource()) && (pos = (resourcePrimKey = this.getResourcePrimKey()).indexOf("_LAYOUT_")) > 0 && (resourceLayout = LayoutLocalServiceUtil.getLayout((long)(resourcePlid = GetterUtil.getLong((String)this.getResourcePrimKey().substring(0, pos))))).isPrivateLayout() && !(resourceLayoutGroup = resourceLayout.getGroup()).isLayoutPrototype() && !resourceLayoutGroup.isLayoutSetPrototype() && !permissionCheckGuestEnabled) {
            filterGuestRole = true;
        }
        ArrayList<String> excludedRoleNames = new ArrayList<String>();
        excludedRoleNames.add("Administrator");
        if (filterGroupRoles) {
            excludedRoleNames.add("Organization Administrator");
            excludedRoleNames.add("Organization Owner");
            excludedRoleNames.add("Site Administrator");
            excludedRoleNames.add("Site Owner");
        }
        if (filterGuestRole) {
            excludedRoleNames.add("Guest");
        }
        long teamGroupId = this._group.getGroupId();
        if (this._group.isLayout()) {
            teamGroupId = this._group.getParentGroupId();
        }
        RoleVisibilityConfiguration stricterRoleVisibilityConfiguration = (RoleVisibilityConfiguration)ConfigurationProviderUtil.getCompanyConfiguration(RoleVisibilityConfiguration.class, (long)themeDisplay.getCompanyId());
        if (Validator.isNull((String)searchTerms.getKeywords())) {
            int count = 0;
            List roles = null;
            if (stricterRoleVisibilityConfiguration.restrictPermissionSelectorRoleVisibility()) {
                count = RoleServiceUtil.getGroupRolesAndTeamRolesCount((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), excludedRoleNames, (int[])this.getRoleTypes(), (long)modelResourceRoleId, (long)teamGroupId);
                roles = RoleServiceUtil.getGroupRolesAndTeamRoles((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), excludedRoleNames, (int[])this.getRoleTypes(), (long)modelResourceRoleId, (long)teamGroupId, (int)roleSearchContainer.getStart(), (int)roleSearchContainer.getEnd());
            } else {
                count = RoleLocalServiceUtil.getGroupRolesAndTeamRolesCount((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), excludedRoleNames, (int[])this.getRoleTypes(), (long)modelResourceRoleId, (long)teamGroupId);
                roles = RoleLocalServiceUtil.getGroupRolesAndTeamRoles((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), excludedRoleNames, (int[])this.getRoleTypes(), (long)modelResourceRoleId, (long)teamGroupId, (int)roleSearchContainer.getStart(), (int)roleSearchContainer.getEnd());
            }
            roleSearchContainer.setResults(roles);
            roleSearchContainer.setTotal(count);
        } else {
            List roles = null;
            roles = stricterRoleVisibilityConfiguration.restrictPermissionSelectorRoleVisibility() ? RoleServiceUtil.getGroupRolesAndTeamRoles((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), excludedRoleNames, (int[])this.getRoleTypes(), (long)modelResourceRoleId, (long)teamGroupId, (int)-1, (int)-1) : RoleLocalServiceUtil.getGroupRolesAndTeamRoles((long)themeDisplay.getCompanyId(), (String)searchTerms.getKeywords(), excludedRoleNames, (int[])this.getRoleTypes(), (long)modelResourceRoleId, (long)teamGroupId, (int)-1, (int)-1);
            List filteredRoles = ListUtil.filter((List)roles, role -> {
                String roleName = StringUtil.toLowerCase((String)role.getTitle(themeDisplay.getLocale()), (Locale)themeDisplay.getLocale());
                return roleName != null && roleName.contains(StringUtil.toLowerCase((String)searchTerms.getKeywords(), (Locale)themeDisplay.getLocale()));
            });
            roleSearchContainer.setResults(ListUtil.subList((List)filteredRoles, (int)roleSearchContainer.getStart(), (int)roleSearchContainer.getEnd()));
            roleSearchContainer.setTotal(filteredRoles.size());
        }
        this._roleSearchContainer = roleSearchContainer;
        return this._roleSearchContainer;
    }

    public int[] getRoleTypes() {
        if (this._roleTypes != null) {
            return this._roleTypes;
        }
        String roleTypesParam = this._getRoleTypesParam();
        if (Validator.isNotNull((String)roleTypesParam)) {
            this._roleTypes = StringUtil.split((String)roleTypesParam, (int)0);
        }
        if (this._roleTypes != null) {
            return this._roleTypes;
        }
        this._roleTypes = RoleConstants.TYPES_REGULAR_AND_SITE;
        if (ResourceActionsUtil.isPortalModelResource((String)this.getModelResource())) {
            this._roleTypes = Objects.equals(this.getModelResource(), Organization.class.getName()) || Objects.equals(this.getModelResource(), User.class.getName()) ? RoleConstants.TYPES_ORGANIZATION_AND_REGULAR : RoleConstants.TYPES_REGULAR;
            return this._roleTypes;
        }
        if (this._group == null) {
            return this._roleTypes;
        }
        Group parentGroup = null;
        if (this._group.isLayout()) {
            parentGroup = GroupLocalServiceUtil.fetchGroup((long)this._group.getParentGroupId());
        }
        this._roleTypes = parentGroup != null ? this._getGroupRoleTypes(parentGroup, this._roleTypes) : this._getGroupRoleTypes(this._group, this._roleTypes);
        return this._roleTypes;
    }

    public String getSearchActionURL() throws Exception {
        PortletURL searchActionURL = this.getIteratorURL();
        return searchActionURL.toString();
    }

    public String getSelResource() {
        this._selResource = this.getModelResource();
        if (Validator.isNotNull((String)this._selResource)) {
            return this._selResource;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)this._getPortletResource());
        this._selResource = portlet.getRootPortletId();
        return this._selResource;
    }

    public String getSelResourceDescription() {
        this._selResourceDescription = this.getModelResourceDescription();
        if (Validator.isNotNull((String)this._selResourceDescription)) {
            return this._selResourceDescription;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)this._getPortletResource());
        HttpSession session = this._httpServletRequest.getSession();
        ServletContext servletContext = session.getServletContext();
        this._selResourceDescription = PortalUtil.getPortletTitle((Portlet)portlet, (ServletContext)servletContext, (Locale)themeDisplay.getLocale());
        return this._selResourceDescription;
    }

    public PortletURL getUpdateRolePermissionsURL() throws ResourcePrimKeyException, WindowStateException {
        int cur = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"cur");
        int delta = ParamUtil.getInteger((HttpServletRequest)this._httpServletRequest, (String)"delta");
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_portlet_configuration_web_portlet_PortletConfigurationPortlet", (String)"ACTION_PHASE");
        portletURL.setParameter("javax.portlet.action", "updateRolePermissions");
        portletURL.setParameter("mvcPath", "/edit_permissions.jsp");
        portletURL.setParameter("cur", String.valueOf(cur));
        portletURL.setParameter("delta", String.valueOf(delta));
        portletURL.setParameter("returnToFullPageURL", this._getReturnToFullPageURL());
        portletURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
        portletURL.setParameter("portletResource", this._getPortletResource());
        portletURL.setParameter("modelResource", this.getModelResource());
        portletURL.setParameter("modelResourceDescription", this.getModelResourceDescription());
        portletURL.setParameter("resourceGroupId", String.valueOf(this._getResourceGroupId()));
        portletURL.setParameter("resourcePrimKey", this.getResourcePrimKey());
        portletURL.setParameter("roleTypes", this._getRoleTypesParam());
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return portletURL;
    }

    private int[] _getGroupRoleTypes(Group group, int[] defaultRoleTypes) {
        if (group == null) {
            return defaultRoleTypes;
        }
        if (group.isOrganization()) {
            return RoleConstants.TYPES_ORGANIZATION_AND_REGULAR_AND_SITE;
        }
        if (group.isCompany() || group.isUser() || group.isUserGroup()) {
            return RoleConstants.TYPES_REGULAR;
        }
        return defaultRoleTypes;
    }

    private String _getPortletResource() {
        if (this._portletResource != null) {
            return this._portletResource;
        }
        this._portletResource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"portletResource");
        return this._portletResource;
    }

    private long _getResourceGroupId() {
        if (this._resourceGroupId != null) {
            return this._resourceGroupId;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._resourceGroupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"resourceGroupId");
        if (this._resourceGroupId == 0L) {
            this._resourceGroupId = themeDisplay.getScopeGroupId();
        }
        return this._resourceGroupId;
    }

    private String _getReturnToFullPageURL() {
        if (this._returnToFullPageURL != null) {
            return this._returnToFullPageURL;
        }
        this._returnToFullPageURL = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"returnToFullPageURL");
        return this._returnToFullPageURL;
    }

    private String _getRoleTypesParam() {
        if (this._roleTypesParam != null) {
            return this._roleTypesParam;
        }
        this._roleTypesParam = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"roleTypes");
        return this._roleTypesParam;
    }
}

