/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.configuration.web.internal.portlet.configuration.icon;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.configuration.icon.BasePortletConfigurationIcon;
import com.liferay.portal.kernel.portlet.configuration.icon.PortletConfigurationIcon;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortletConfigurationIcon.class})
public class PermissionsPortletConfigurationIcon
extends BasePortletConfigurationIcon {
    private static final boolean _STAGING_LIVE_GROUP_LOCKING_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"staging.live.group.locking.enabled"));
    private static final Log _log = LogFactoryUtil.getLog(PermissionsPortletConfigurationIcon.class);
    private PortletLocalService _portletLocalService;

    public String getMessage(PortletRequest portletRequest) {
        return LanguageUtil.get((ResourceBundle)this.getResourceBundle(this.getLocale(portletRequest)), (String)"permissions");
    }

    public String getURL(PortletRequest portletRequest, PortletResponse portletResponse) {
        try {
            String returnToFullPageURL = ParamUtil.getString((PortletRequest)portletRequest, (String)"returnToFullPageURL");
            PortletURL portletURL = PortletProviderUtil.getPortletURL((PortletRequest)portletRequest, (String)"com.liferay.portlet.configuration.kernel.util.PortletConfigurationApplicationType$PortletConfiguration", (PortletProvider.Action)PortletProvider.Action.VIEW);
            portletURL.setParameter("mvcPath", "/edit_permissions.jsp");
            portletURL.setParameter("returnToFullPageURL", returnToFullPageURL);
            portletURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletURL.setParameter("portletResource", portletDisplay.getId());
            portletURL.setParameter("resourcePrimKey", PortletPermissionUtil.getPrimaryKey((long)themeDisplay.getPlid(), (String)portletDisplay.getId()));
            portletURL.setWindowState(LiferayWindowState.POP_UP);
            return portletURL.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public double getWeight() {
        return 13.0;
    }

    public boolean isShow(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String portletId = portletDisplay.getId();
        if (Validator.isNotNull((String)portletDisplay.getPortletResource())) {
            portletId = portletDisplay.getPortletResource();
        }
        boolean showPermissionsIcon = false;
        Layout layout = themeDisplay.getLayout();
        Group group = themeDisplay.getScopeGroup();
        if (_STAGING_LIVE_GROUP_LOCKING_ENABLED || !group.hasStagingGroup()) {
            try {
                if (PortletPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)layout, (String)portletId, (String)"PERMISSIONS")) {
                    showPermissionsIcon = true;
                }
            }
            catch (PortalException pe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)pe, (Throwable)pe);
                }
                showPermissionsIcon = false;
            }
        }
        if (layout.isLayoutPrototypeLinkActive()) {
            showPermissionsIcon = false;
        }
        if (layout.isTypeControlPanel()) {
            showPermissionsIcon = false;
        }
        if (this.isEmbeddedPersonalApplicationLayout(layout)) {
            showPermissionsIcon = false;
        }
        return showPermissionsIcon;
    }

    public boolean isUseDialog() {
        return true;
    }

    @Reference(unbind="-")
    protected void setPortletLocalService(PortletLocalService portletLocalService) {
        this._portletLocalService = portletLocalService;
    }
}

