/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.configuration.web.internal.servlet.taglib.util;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemList;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.settings.ArchivedSettings;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class ArchivedSettingsActionDropdownItemsProvider {
    private final ArchivedSettings _archivedSettings;
    private final HttpServletRequest _httpServletRequest;
    private String _portletResource;
    private final RenderResponse _renderResponse;
    private final ThemeDisplay _themeDisplay;

    public ArchivedSettingsActionDropdownItemsProvider(ArchivedSettings archivedSettings, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._archivedSettings = archivedSettings;
        this._renderResponse = renderResponse;
        this._httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        this._themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public List<DropdownItem> getActionDropdownItems() {
        return new DropdownItemList(){
            {
                this.add(ArchivedSettingsActionDropdownItemsProvider.this._getRestoreArchivedSetupActionUnsafeConsumer());
                this.add(ArchivedSettingsActionDropdownItemsProvider.this._getDeleteArchivedSetupActionUnsafeConsumer());
            }
        };
    }

    private UnsafeConsumer<DropdownItem, Exception> _getDeleteArchivedSetupActionUnsafeConsumer() {
        PortletURL deleteArchivedSetupsURL = this._renderResponse.createActionURL();
        deleteArchivedSetupsURL.setParameter("javax.portlet.action", "deleteArchivedSetups");
        deleteArchivedSetupsURL.setParameter("mvcPath", "/edit_configuration_templates.jsp");
        deleteArchivedSetupsURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        deleteArchivedSetupsURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
        deleteArchivedSetupsURL.setParameter("portletResource", this._getPortletResource());
        deleteArchivedSetupsURL.setParameter("name", this._archivedSettings.getName());
        return dropdownItem -> {
            dropdownItem.putData("action", "deleteArchivedSetups");
            dropdownItem.putData("deleteArchivedSetupsURL", deleteArchivedSetupsURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"delete"));
        };
    }

    private String _getPortletResource() {
        if (this._portletResource != null) {
            return this._portletResource;
        }
        this._portletResource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"portletResource");
        return this._portletResource;
    }

    private UnsafeConsumer<DropdownItem, Exception> _getRestoreArchivedSetupActionUnsafeConsumer() {
        PortletURL restoreArchivedSetupURL = this._renderResponse.createActionURL();
        restoreArchivedSetupURL.setParameter("javax.portlet.action", "restoreArchivedSetup");
        restoreArchivedSetupURL.setParameter("mvcPath", "/edit_configuration_templates.jsp");
        restoreArchivedSetupURL.setParameter("redirect", this._themeDisplay.getURLCurrent());
        restoreArchivedSetupURL.setParameter("portletConfiguration", Boolean.TRUE.toString());
        restoreArchivedSetupURL.setParameter("portletResource", this._getPortletResource());
        restoreArchivedSetupURL.setParameter("name", this._archivedSettings.getName());
        return dropdownItem -> {
            dropdownItem.putData("action", "restoreArchivedSetup");
            dropdownItem.putData("restoreArchivedSetupURL", restoreArchivedSetupURL.toString());
            dropdownItem.setLabel(LanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"apply"));
        };
    }
}

