/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.configuration.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.settings.ArchivedSettings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.configuration.web.internal.servlet.taglib.util.ArchivedSettingsActionDropdownItemsProvider;
import com.liferay.portlet.configuration.web.internal.util.comparator.ArchivedSettingsModifiedDateComparator;
import com.liferay.portlet.configuration.web.internal.util.comparator.ArchivedSettingsNameComparator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

public class PortletConfigurationTemplatesDisplayContext {
    private SearchContainer _archivedSettingsSearch;
    private String _displayStyle;
    private final HttpServletRequest _httpServletRequest;
    private final String _moduleName;
    private String _orderByCol;
    private String _orderByType;
    private String _portletResource;
    private String _redirect;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private String _returnToFullPageURL;

    public PortletConfigurationTemplatesDisplayContext(HttpServletRequest httpServletRequest, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._httpServletRequest = httpServletRequest;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
        this._moduleName = (String)renderRequest.getAttribute("MODULE_NAME");
    }

    public List<DropdownItem> getActionDropdownItems(ArchivedSettings archivedSettings) {
        ArchivedSettingsActionDropdownItemsProvider archivedSettingsActionDropdownItemsProvider = new ArchivedSettingsActionDropdownItemsProvider(archivedSettings, this._renderRequest, this._renderResponse);
        return archivedSettingsActionDropdownItemsProvider.getActionDropdownItems();
    }

    public SearchContainer getArchivedSettingsSearchContainer() {
        if (this._archivedSettingsSearch != null) {
            return this._archivedSettingsSearch;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SearchContainer archivedSettingsSearch = new SearchContainer((PortletRequest)this._renderRequest, null, null, "cur", SearchContainer.DEFAULT_DELTA, this.getPortletURL(), null, "there-are-no-configuration-templates");
        archivedSettingsSearch.setRowChecker((RowChecker)new EmptyOnClickRowChecker((PortletResponse)this._renderResponse));
        archivedSettingsSearch.setOrderByCol(this.getOrderByCol());
        Portlet selPortlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)this.getPortletResource());
        List archivedSettingsList = SettingsFactoryUtil.getPortletInstanceArchivedSettingsList((long)themeDisplay.getScopeGroupId(), (String)selPortlet.getRootPortletId());
        boolean orderByAsc = false;
        if (Objects.equals(this.getOrderByType(), "asc")) {
            orderByAsc = true;
        }
        OrderByComparator orderByComparator = null;
        orderByComparator = Objects.equals(this.getOrderByCol(), "modified-date") ? new ArchivedSettingsModifiedDateComparator(orderByAsc) : new ArchivedSettingsNameComparator(orderByAsc);
        archivedSettingsSearch.setOrderByComparator(orderByComparator);
        archivedSettingsList = ListUtil.sort((List)archivedSettingsList, (Comparator)orderByComparator);
        archivedSettingsSearch.setOrderByType(this.getOrderByType());
        int archivedSettingsCount = archivedSettingsList.size();
        archivedSettingsSearch.setTotal(archivedSettingsCount);
        archivedSettingsList = ListUtil.subList((List)archivedSettingsList, (int)archivedSettingsSearch.getStart(), (int)archivedSettingsSearch.getEnd());
        archivedSettingsSearch.setResults(archivedSettingsList);
        this._archivedSettingsSearch = archivedSettingsSearch;
        return this._archivedSettingsSearch;
    }

    public String getDisplayStyle() {
        if (Validator.isNotNull((String)this._displayStyle)) {
            return this._displayStyle;
        }
        this._displayStyle = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"displayStyle", (String)"list");
        return this._displayStyle;
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public String getOrderByCol() {
        if (Validator.isNotNull((String)this._orderByCol)) {
            return this._orderByCol;
        }
        this._orderByCol = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByCol", (String)"name");
        return this._orderByCol;
    }

    public String getOrderByType() {
        if (Validator.isNotNull((String)this._orderByType)) {
            return this._orderByType;
        }
        this._orderByType = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"orderByType", (String)"asc");
        return this._orderByType;
    }

    public String getPortletResource() {
        if (this._portletResource != null) {
            return this._portletResource;
        }
        this._portletResource = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"portletResource");
        return this._portletResource;
    }

    public PortletURL getPortletURL() {
        String orderByType;
        String orderByCol;
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("mvcPath", "/edit_configuration_templates.jsp");
        portletURL.setParameter("redirect", this.getRedirect());
        portletURL.setParameter("returnToFullPageURL", this.getReturnToFullPageURL());
        portletURL.setParameter("portletResource", this.getPortletResource());
        String displayStyle = this.getDisplayStyle();
        if (Validator.isNotNull((String)displayStyle)) {
            portletURL.setParameter("displayStyle", displayStyle);
        }
        if (Validator.isNotNull((String)(orderByCol = this.getOrderByCol()))) {
            portletURL.setParameter("orderByCol", orderByCol);
        }
        if (Validator.isNotNull((String)(orderByType = this.getOrderByType()))) {
            portletURL.setParameter("orderByType", orderByType);
        }
        return portletURL;
    }

    public String getRedirect() {
        if (this._redirect != null) {
            return this._redirect;
        }
        this._redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        return this._redirect;
    }

    public String getReturnToFullPageURL() {
        if (this._returnToFullPageURL != null) {
            return this._returnToFullPageURL;
        }
        this._returnToFullPageURL = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"returnToFullPageURL");
        return this._returnToFullPageURL;
    }
}

