Liferay.Loader.define('portlet-configuration-web$liferay-amd-loader@4.0.0/bin/build-demo', ['module', 'exports', 'require', 'portlet-configuration-web$fs-extra', 'portlet-configuration-web$globby', 'portlet-configuration-web$path', './util'], function (module, exports, require) {
	var define = undefined;
	/**
  * © 2014 Liferay, Inc. <https://liferay.com>
  *
  * SPDX-License-Identifier: LGPL-3.0-or-later
  */

	const fs = require('portlet-configuration-web$fs-extra');
	const globby = require('portlet-configuration-web$globby');
	const path = require('portlet-configuration-web$path');
	const { copy, run } = require('./util');

	if (!fs.existsSync('build/loader/loader-debug.js')) {
		run('npm', 'run', 'build');
	}

	copy('build/loader/loader-debug.js', 'build/demo/loader-debug.js');
	copy('src/demo/index.html', 'build/demo/index.html');
	copy('src/demo/config.js', 'build/demo/config.js');

	fs.mkdirsSync(`build/demo/resolutions`);
	globby.sync('src/demo/resolutions/*').forEach(filePath => {
		const fileName = path.basename(filePath);

		copy(`src/demo/resolutions/${fileName}`, `build/demo/resolutions/${fileName}`);
	});

	globby.sync('src/demo/modules/**/*.js').forEach(file => {
		const filePath = file.substring('src/demo/modules/'.length);
		const dirname = path.dirname(filePath);

		fs.mkdirsSync(`build/demo/modules/${dirname}`);

		copy(path.join('src', 'demo', 'modules', filePath), path.join('build', 'demo', 'modules', filePath));
	});
});
//# sourceMappingURL=build-demo.js.map