Liferay.Loader.define('portlet-configuration-web$liferay-amd-loader@4.0.0/webpack.config', ['module', 'exports', 'require', 'portlet-configuration-web$path', 'portlet-configuration-web$uglifyjs-webpack-plugin'], function (module, exports, require) {
	var define = undefined;
	/**
  * © 2014 Liferay, Inc. <https://liferay.com>
  *
  * SPDX-License-Identifier: LGPL-3.0-or-later
  */

	/* eslint-env node */

	const path = require('portlet-configuration-web$path');
	const UglifyJsPlugin = require('portlet-configuration-web$uglifyjs-webpack-plugin');

	module.exports = ({ flavor }) => {
		const baseConfig = {
			entry: path.resolve(__dirname, 'src/loader/bootstrap.js'),
			output: {
				path: path.resolve(__dirname, 'build/loader')
			},
			devtool: 'source-map',
			module: {
				rules: [{
					test: /\.js$/,
					exclude: /node_modules/,
					use: [{
						loader: 'babel-loader',
						options: {}
					}]
				}]
			}
		};

		const flavorConfig = {
			debug: {
				output: Object.assign({}, baseConfig.output, {
					filename: 'loader-debug.js'
				})
			},
			prod: {
				output: Object.assign({}, baseConfig.output, {
					filename: 'loader.js'
				})
			},
			min: {
				output: Object.assign({}, baseConfig.output, {
					filename: 'loader-min.js'
				}),
				plugins: [new UglifyJsPlugin({
					sourceMap: true
				})]
			}
		};

		return Object.assign({}, baseConfig, flavorConfig[flavor]);
	};
});
//# sourceMappingURL=webpack.config.js.map