/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dependency.factory.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.portlet.PortletDependency;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.url.builder.AbsolutePortalURLBuilder;
import com.liferay.portal.url.builder.PortletDependencyAbsolutePortalURLBuilder;
import com.liferay.portal.util.PropsValues;

public class PortletDependencyImpl
implements PortletDependency {
    private static final long serialVersionUID = 1L;
    private final AbsolutePortalURLBuilder _absolutePortalURLBuilder;
    private final String _markup;
    private final String _name;
    private final String _scope;
    private final PortletDependency.Type _type;
    private final String _version;

    public PortletDependencyImpl(String name, String scope, String version, String markup, AbsolutePortalURLBuilder absolutePortalURLBuilder) {
        this._name = name;
        this._scope = scope;
        this._version = version;
        this._markup = markup;
        this._absolutePortalURLBuilder = absolutePortalURLBuilder;
        this._type = this._name == null ? PortletDependency.Type.OTHER : (this._name.endsWith(".css") ? PortletDependency.Type.CSS : (this._name.endsWith(".js") ? PortletDependency.Type.JAVASCRIPT : (Validator.isNotNull((String)markup) ? ((markup = StringUtil.trim((String)markup)).regionMatches(true, 0, "<script", 0, 7) ? PortletDependency.Type.JAVASCRIPT : (markup.regionMatches(true, 0, "<link", 0, 5) ? PortletDependency.Type.CSS : PortletDependency.Type.OTHER)) : PortletDependency.Type.OTHER)));
    }

    public String getName() {
        return this._name;
    }

    public String getScope() {
        return this._scope;
    }

    public PortletDependency.Type getType() {
        return this._type;
    }

    public String getVersion() {
        return this._version;
    }

    public String toString() {
        StringBundler sb = this.toStringBundler();
        return sb.toString();
    }

    public StringBundler toStringBundler() {
        if (Validator.isNull((String)this._markup)) {
            StringBundler sb = new StringBundler(8);
            if (this._type == PortletDependency.Type.CSS) {
                sb.append("<link ");
                sb.append("href=\"");
                sb.append(this._getURL());
                sb.append("\" type=\"text/css\"></link>");
            } else if (this._type == PortletDependency.Type.JAVASCRIPT) {
                sb.append("<script ");
                sb.append("src=\"");
                sb.append(this._getURL());
                sb.append("\" type=\"text/javascript\"></script>");
            } else {
                sb.append("<!-- Unknown portlet resource dependency type ");
                sb.append("name=\"");
                sb.append(this._name);
                sb.append("\" scope=\"");
                sb.append(this._scope);
                sb.append("\" version=\"");
                sb.append(this._version);
                sb.append("\" -->");
            }
            return sb;
        }
        return new StringBundler(this._markup);
    }

    private String _getURL() {
        PortletDependencyAbsolutePortalURLBuilder buildableAbsolutePortalURLBuilder = this._absolutePortalURLBuilder.forPortletDependency((PortletDependency)this, PropsValues.PORTLET_DEPENDENCY_CSS_URN, PropsValues.PORTLET_DEPENDENCY_JAVASCRIPT_URN);
        return buildableAbsolutePortalURLBuilder.build();
    }
}

