/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portlet.display.template.constants;

import com.liferay.portal.kernel.template.TemplateConstants;

/**
 * @author Juan Fernández
 * @author Eduardo García
 */
public class PortletDisplayTemplateConstants {

	public static final String CURRENT_URL = "currentURL";

	public static final String DISPLAY_STYLE_PREFIX = "ddmTemplate_";

	public static final String DISPLAY_TEMPLATE_EXPORT = "export";

	public static final String DISPLAY_TEMPLATE_IMPORT = "import";

	public static final String ENTRIES = "entries";

	public static final String ENTRY = "entry";

	public static final String FREEMARKER_SERVLET_APPLICATION =
		"__FreeMarkerServlet.Application__";

	public static final String FREEMARKER_SERVLET_REQUEST =
		"__FreeMarkerServlet.Request__";

	public static final String LOCALE = "locale";

	public static final String PORTLET_PREFERENCES = "portletPreferences";

	public static final String RENDER_REQUEST = "renderRequest";

	public static final String RENDER_RESPONSE = "renderResponse";

	public static final String REQUEST = "request";

	public static final String REQUEST_HASH = "requestHash";

	public static final String RESOURCE_REQUEST = "resourceRequest";

	public static final String RESOURCE_RESPONSE = "resourceResponse";

	public static final String TAGLIB_LIFERAY = "taglibLiferay";

	public static final String TAGLIB_LIFERAY_HASH = "taglibLiferayHash";

	public static final String TEMPLATE_ID = TemplateConstants.TEMPLATE_ID;

	public static final String THEME = "theme";

	public static final String THEME_DISPLAY = "themeDisplay";

}