/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.display.template.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BasePortletPreferencesUpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletPreferences;

public abstract class BaseUpgradePortletPreferences
extends BasePortletPreferencesUpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseUpgradePortletPreferences.class);
    private final Map<Long, String> _groupIdMap = new ConcurrentHashMap<Long, String>();
    private final Map<Long, Map<String, Long>> _groupKeyMap = new ConcurrentHashMap<Long, Map<String, Long>>();
    private final Map<Long, Long> _plidMap = new ConcurrentHashMap<Long, Long>();

    protected String getGroupExternalReferenceCode(long groupId) throws Exception {
        return this._groupIdMap.computeIfAbsent(groupId, curGroupId -> this._getGroupExternalReferenceCode((long)curGroupId));
    }

    protected long getGroupId(long companyId, String groupKey) throws Exception {
        Map companyMap = this._groupKeyMap.computeIfAbsent(companyId, curCompanyId -> new ConcurrentHashMap());
        return companyMap.computeIfAbsent(groupKey, curGroupKey -> {
            Object[] group = this._getGroup(companyId, (String)curGroupKey);
            if (group == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get group for company ID ", companyId, " and group key ", curGroupKey}));
                }
                return 0L;
            }
            String externalReferenceCode = (String)group[0];
            long groupId = (Long)group[1];
            this._groupIdMap.computeIfAbsent(groupId, curGroupId -> externalReferenceCode);
            return groupId;
        });
    }

    protected abstract String[] getPortletIds();

    protected String getScopeExternalReferenceCode(long plid, long scopeGroupId) throws Exception {
        long layoutGroupId = this._getLayoutGroupId(plid);
        if (layoutGroupId == 0L || layoutGroupId == scopeGroupId) {
            return "";
        }
        return this.getGroupExternalReferenceCode(scopeGroupId);
    }

    protected String getScopeExternalReferenceCode(long companyId, long plid, String scopeGroupKey) throws Exception {
        long layoutGroupId = this._getLayoutGroupId(plid);
        long scopeGroupId = this.getGroupId(companyId, scopeGroupKey);
        if (layoutGroupId == 0L || layoutGroupId == scopeGroupId) {
            return "";
        }
        return this.getGroupExternalReferenceCode(scopeGroupId);
    }

    protected abstract void upgradePreferences(long var1, long var3, int var5, long var6, String var8, PortletPreferences var9) throws Exception;

    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)xml);
        String displayStyleGroupKey = portletPreferences.getValue("displayStyleGroupKey", null);
        String groupExternalReferenceCode = null;
        if (Validator.isNotNull((String)displayStyleGroupKey)) {
            groupExternalReferenceCode = this.getScopeExternalReferenceCode(companyId, plid, displayStyleGroupKey);
        } else {
            long displayStyleGroupId = GetterUtil.getLong((String)portletPreferences.getValue("displayStyleGroupId", null));
            if (displayStyleGroupId > 0L) {
                groupExternalReferenceCode = this.getScopeExternalReferenceCode(plid, displayStyleGroupId);
            }
        }
        if (Validator.isNotNull((String)groupExternalReferenceCode)) {
            portletPreferences.setValue("displayStyleGroupExternalReferenceCode", groupExternalReferenceCode);
        }
        this.upgradePreferences(companyId, ownerId, ownerType, plid, portletId, portletPreferences);
        return PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] _getGroup(long companyId, String groupKey) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select externalReferenceCode, groupId from Group_ where companyId = ? and groupKey = ?");){
            preparedStatement.setLong(1, companyId);
            preparedStatement.setString(2, groupKey);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return null;
                Object[] objectArray = new Object[]{resultSet.getString("externalReferenceCode"), resultSet.getLong("groupId")};
                return objectArray;
            }
        }
        catch (Exception exception) {
            if (!_log.isWarnEnabled()) return null;
            _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to get group for company ID ", companyId, " and group key ", groupKey}), (Throwable)exception);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String _getGroupExternalReferenceCode(long groupId) {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select externalReferenceCode from Group_ where groupId = ?");){
            preparedStatement.setLong(1, groupId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return "";
                String string = resultSet.getString("externalReferenceCode");
                return string;
            }
        }
        catch (Exception exception) {
            if (!_log.isWarnEnabled()) return "";
            _log.warn((Object)("Unable to get external reference code for group ID " + groupId), (Throwable)exception);
        }
        return "";
    }

    private long _getLayoutGroupId(long plid) {
        return this._plidMap.computeIfAbsent(plid, curPlid -> {
            try {
                Object[] layout = this.getLayout((long)curPlid);
                return (long)((Long)layout[0]);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get layout for PLID " + curPlid), (Throwable)exception);
                }
                return 0L;
            }
        });
    }
}

