/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.display.template.internal.exportimport.portlet.preferences.processor;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.display.template.PortletDisplayTemplate;
import com.liferay.portlet.display.template.exportimport.portlet.preferences.processor.PortletDisplayTemplateRegister;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PortletDisplayTemplateImportCapability
implements Capability {
    private static final Log _log = LogFactoryUtil.getLog(PortletDisplayTemplateImportCapability.class);
    private final Portal _portal;
    private final PortletDisplayTemplate _portletDisplayTemplate;
    private final PortletDisplayTemplateRegister _portletDisplayTemplateImportRegister;
    private final PortletLocalService _portletLocalService;

    public PortletDisplayTemplateImportCapability(Portal portal, PortletLocalService portletLocalService, PortletDisplayTemplate portletDisplayTemplate, PortletDisplayTemplateRegister portletDisplayTemplateImportRegister) {
        this._portal = portal;
        this._portletLocalService = portletLocalService;
        this._portletDisplayTemplate = portletDisplayTemplate;
        this._portletDisplayTemplateImportRegister = portletDisplayTemplateImportRegister;
    }

    public PortletPreferences process(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        try {
            return this.importDisplayStyle(portletDataContext, portletDataContext.getPortletId(), portletPreferences);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return portletPreferences;
        }
    }

    protected long getClassNameId(PortletDataContext portletDataContext, String portletId) {
        Portlet portlet = this._portletLocalService.getPortletById(portletDataContext.getCompanyId(), portletId);
        TemplateHandler templateHandler = portlet.getTemplateHandlerInstance();
        if (templateHandler == null) {
            return 0L;
        }
        return this._portal.getClassNameId(templateHandler.getClassName());
    }

    protected PortletPreferences importDisplayStyle(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        PortletPreferences processedPreferences = portletPreferences;
        String displayStyle = this._portletDisplayTemplateImportRegister.getDisplayStyle(portletDataContext, portletId, portletPreferences);
        if (Validator.isNull((String)displayStyle) || !displayStyle.startsWith("ddmTemplate_")) {
            return processedPreferences;
        }
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, DDMTemplate.class);
        long displayStyleGroupId = this._portletDisplayTemplateImportRegister.getDisplayStyleGroupId(portletDataContext, portletId, portletPreferences);
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = MapUtil.getLong((Map)groupIds, (long)displayStyleGroupId, (long)displayStyleGroupId);
        DDMTemplate ddmTemplate = this._portletDisplayTemplate.getPortletDisplayTemplateDDMTemplate(groupId, this.getClassNameId(portletDataContext, portletId), displayStyle, false);
        if (ddmTemplate != null) {
            portletPreferences.setValue("displayStyleGroupId", String.valueOf(ddmTemplate.getGroupId()));
        } else {
            portletPreferences.setValue("displayStyleGroupId", "");
        }
        return processedPreferences;
    }
}

