/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.prose;

import com.liferay.poshi.core.prose.BasePoshiProse;
import com.liferay.poshi.core.prose.PoshiProseMatcher;
import com.liferay.poshi.core.util.Dom4JUtil;
import com.liferay.poshi.core.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.dom4j.tree.DefaultAttribute;

public class PoshiProseStatement
extends BasePoshiProse {
    protected static final String[] KEYWORDS = new String[]{"*", "And", "Given", "Then", "When"};
    private static final String _LINE_SEPARATOR = System.lineSeparator();
    private static final Pattern _multiLineStringPattern = Pattern.compile("(?s)\\s*\"\"\".*?\\R(.*?)\\s*\"\"\"");
    private static final Pattern _tablePattern = Pattern.compile("(?s)\\s*(\\|.*\\|$)");
    private static final Pattern _varValuePattern = Pattern.compile("\"(.*?)\"");
    private final PoshiProseMatcher _poshiProseMatcher;
    private final String _proseStatement;
    private final Map<String, String> _varMap = new LinkedHashMap<String, String>();

    public PoshiProseStatement(String proseStatement) {
        for (String proseKeyword : KEYWORDS) {
            if (!proseStatement.startsWith(proseKeyword)) continue;
            proseStatement = StringUtil.replaceFirst(proseStatement, proseKeyword, "");
            break;
        }
        this._proseStatement = proseStatement;
        proseStatement = this.formatProseStatement(proseStatement);
        String proseStatementMatchingString = this.getProseStatementMatchingString();
        this._poshiProseMatcher = PoshiProseMatcher.getPoshiProseMatcher(proseStatementMatchingString);
        if (this._poshiProseMatcher == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to find matching prose for '");
            sb.append(proseStatementMatchingString);
            sb.append("'");
            throw new RuntimeException(sb.toString());
        }
        List<String> varNames = this._poshiProseMatcher.getVarNames();
        ArrayList<String> varValues = new ArrayList<String>();
        Matcher varValueMatcher = _varValuePattern.matcher(proseStatement);
        while (varValueMatcher.find()) {
            varValues.add(varValueMatcher.group(1));
        }
        for (int i = 0; i < varNames.size(); ++i) {
            String varValue;
            String varName = varNames.get(i);
            if (this._varMap.containsKey(varName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Duplicate variable value assignment: ${");
                sb.append(varName);
                sb.append("} already has a value of ");
                sb.append(this._varMap.get(varName));
                sb.append("\nProse statement: ");
                sb.append(this._proseStatement);
                sb.append("\nMatching macro prose statement: ");
                sb.append(this._poshiProseMatcher.getPoshiProse());
                throw new RuntimeException(sb.toString());
            }
            if (i + 1 == varNames.size()) {
                Matcher multiLineStringMatcher = _multiLineStringPattern.matcher(proseStatement);
                Matcher tableMatcher = _tablePattern.matcher(proseStatement);
                varValue = multiLineStringMatcher.find() ? multiLineStringMatcher.group(1) : (tableMatcher.find() ? tableMatcher.group(1) : (String)varValues.get(i));
            } else {
                varValue = (String)varValues.get(i);
            }
            this._varMap.put(varName, varValue);
        }
    }

    @Override
    public Element toElement() {
        Element element = Dom4JUtil.getNewElement("execute", null, new DefaultAttribute("macro", this._poshiProseMatcher.getMacroNamespacedClassCommandName()));
        Element proseElement = Dom4JUtil.getNewElement("prose", element, new Object[0]);
        proseElement.addCDATA(this._proseStatement);
        for (Map.Entry<String, String> varMapEntry : this._varMap.entrySet()) {
            Element varElement = Dom4JUtil.getNewElement("var", null, new DefaultAttribute("name", varMapEntry.getKey()));
            String value = varMapEntry.getValue();
            if (value.matches(_tablePattern.pattern())) {
                varElement.addAttribute("type", "Table");
                varElement.addCDATA(value);
            } else if (value.contains(_LINE_SEPARATOR)) {
                varElement.addCDATA(value);
            } else {
                varElement.addAttribute("value", value);
            }
            Dom4JUtil.addToElement(element, varElement);
        }
        return element;
    }

    protected String formatProseStatement(String proseStatement) {
        String formattedProseStatement = proseStatement.trim();
        return formattedProseStatement.replaceAll(_LINE_SEPARATOR + "\t\t", _LINE_SEPARATOR);
    }

    protected String getProseStatementMatchingString() {
        String proseStatement = this.formatProseStatement(this._proseStatement);
        String proseStatementMatchingString = proseStatement.replaceAll(_multiLineStringPattern.pattern(), " \"\"");
        proseStatementMatchingString = proseStatementMatchingString.replaceAll(_tablePattern.pattern(), " \"\"");
        proseStatementMatchingString = proseStatementMatchingString.replaceAll(_varValuePattern.pattern(), "\"\"");
        return proseStatementMatchingString;
    }
}

